from setuptools import setup, find_packages


# Function to convert simple ETS project names and versions to a requirements
# spec that works for both development builds and stable builds.  Allows
# a caller to specify a max version, which is intended to work along with
# Enthought's standard versioning scheme -- see the following write up:
#    https://svn.enthought.com/enthought/wiki/EnthoughtVersionNumbers
def etsdep(p, min, max=None, literal=False):
    require = '%s >=%s.dev' % (p, min)
    if max is not None:
        if literal is False:
            require = '%s, <%sa' % (require, max)
        else:
            require = '%s, <%s' % (require, max)
    return require


# Declare our ETS project dependencies.
GOTCHA = etsdep('enthought.gotcha', '2.0.4', '3.0')
KIVA_TRAITS = etsdep('enthought.kiva[traits]', '2.0.4', '3.0')
TRAITS_UI = etsdep('enthought.traits[ui]', '2.0.5', '3.0')
TRAITSUIWX = etsdep('enthought.traits.ui.wx', '2.0.5', '3.0')
UTIL = etsdep('enthought.util', '2.0.4', '3.0')


setup(
    author = 'Enthought, Inc',
    author_email = 'info@enthought.com',
    dependency_links = [
        'http://code.enthought.com/enstaller/eggs/source',
        'http://code.enthought.com/enstaller/eggs/source/unstable',
        ],
    description = 'Kiva-based GUI Window and Component package',
    extras_require = {
        'gotcha': [
            GOTCHA,
            ],
        "wx": [
            TRAITSUIWX,
            ],

        # All non-ets dependencies should be in this extra to ensure users can
        # decide whether to require them or not.
        'nonets': [
            "numpy>=1.0.2",
            ],
        },
    include_package_data = True,
    install_requires = [
        KIVA_TRAITS,
        TRAITS_UI,
        UTIL,
        ],
    license = 'BSD',
    name = 'enthought.enable',
    namespace_packages = [
        "enthought",
        ],
    packages = find_packages(exclude=['examples', 'integrationtests']),
    tests_require = [
        'nose >= 0.9',
        ],
    test_suite = 'nose.collector',
    url  = 'http://code.enthought.com/ets',
    version = '1.9.4',
    zip_safe = False,
    )

