import os

#!/usr/bin/env python
def configuration(parent_package='enthought',top_path=None):
    from numpy.distutils.misc_util import Configuration
    config = Configuration('enable',parent_package,top_path)
    config.set_options(ignore_setup_xxx_py=True,
                       assume_default_configuration=True,
                       delegate_options_to_subpackages=True,
                       quiet=True)

    # for unknown reasons, if ../__init__.py isn't referred to by its absolute
    # path, enthought/traits/__init__.py gets copied instead
    config.add_data_files(('..', os.path.abspath(os.path.join('..','__init__.py'))))

    config.add_subpackage('drawing')
    config.add_data_dir('drawing/tests')
    config.add_subpackage('drawing_canvas')

    config.add_subpackage('image')
    #config.add_data_dir('image/images')
    config.add_data_files('image/*.zip')
    config.add_subpackage('image_frame')
    #config.add_data_dir('image_frame/images')
    config.add_data_files('image_frame/*.zip')
    config.add_subpackage('image_title')
    #config.add_data_dir('image_title/images')
    config.add_data_files('image_title/*.zip')
    
    config.add_subpackage('om')
    config.add_data_files('om/images/*.png')
    config.add_data_dir('om/tests')

    config.add_subpackage('tk')
    config.add_subpackage('wx')

    config.add_data_files('demo/*.py', 'demo/*.jpg')
    config.add_data_files('images/*.gif', 'images/*.png')
    #config.add_data_dir('tests')
    config.add_data_files('*.zip','*.txt')

    return config

if __name__ == "__main__":
    try:
        from numpy.distutils.core import setup
    except ImportError:
        execfile('setup_enable.py')
    else:
        setup(version='0.2.1',
           description  = 'Kiva-based GUI Window and Component package',
           author       = 'Enthought, Inc',
           author_email = 'info@enthought.com',
           url          = 'http://code.enthought.com/chaco',
           license      = 'BSD',
           zip_safe     = False,
           configuration=configuration)
