#include <errno.h>
#include <time.h>
#include <signal.h>
#include <gtk/gtk.h>
#include <gdk/gdkrgb.h>

#include "guiutils.h"
#include "conmsg.h"
#include "pulist.h"
#include "cdialog.h"
#include "csd.h"
#include "fsd.h"
#include "fb.h"
#include "progressdialog.h"
#include "pdialog.h"
#include "fprompt.h"

#include "edv_types.h"
#include "endeavour2.h"
#include "edv_cb.h"
#include "config.h"


edv_core_struct	*edv_core;


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	"Focus on the family", that means actually caring and expending
 *	your time and energy on your family members at a higher
 *	priority level and amount than at political rallies against
 *	homosexual families.
 *
 *	What does that have to do with this code? Because this is me,
 *	Tara, the head programer of this project writing this and I
 *	can write anything that I want here... this is my project
 *	afterall.
 *
 *	I wrote that because it has been a very difficult life for me
 *	and I'm not sure exactly why I decided to put this in here
 *	tonight... My (genetic) father was an avid supporter of "Family
 *	values", however he abandoned my mom and I for most of my life
 *	and when he was around he subjected us to his "war" on
 *	homosexual families and other individuals and groups he labeled
 *	as part of the "liberal army". Many individuals who claim to
 *	"protect family values" are often abusing their own family
 *	members behind close doors.
 *
 *	I spent hundreds of hours writing this program for you, I only
 *	wanted to share a part of my life, not my political views, in
 *	this. This program is here, for you, because of me, and there
 *	are things that I went through to make this a reality. I only
 *	want to share a part of the human side of this author. She is
 *	not just another name, @ sign, site address, she wrote this for
 *	you and she also had her own human experience. She asks nothing
 *	in return.
 *
 *	Tara - 2007 Mar 4
 */


int main(int argc, char *argv[])
{
	gboolean initialized_gtk = FALSE;
	const gchar *s;
	gint err_rtn = 0;
	gboolean	safe_mode = FALSE,
			show_stdout_dialog = TRUE,
			show_stderr_dialog = TRUE;
	edv_core_struct *core;

	/* Reset the globals */
	edv_core = NULL;

	/* Handle general arguments
	 *
	 * This only handles the arguments for --help, --version, and
	 * other general arguments, more specific arguments are handled
	 * in EDVNew()
	 */
	if(argc > 1)
	{
	    gint i;
	    const gchar *arg;

	    for(i = 1; i < argc; i++)
	    {
		arg = argv[i];
		if(STRISEMPTY(arg))
		    continue;

		/* Help? */
		if(!g_strcasecmp(arg, "--help") ||
		   !g_strcasecmp(arg, "-help") ||
		   !g_strcasecmp(arg, "--h") ||
		   !g_strcasecmp(arg, "-h") ||
		   !g_strcasecmp(arg, "-?")
		)
		{
		    g_print("%s", PROG_HELP_MESG);
		    return(0);
		}
		/* Version? */
		else if(!g_strcasecmp(arg, "--version") ||
			!g_strcasecmp(arg, "-version")
		)
		{
		    g_print(
			"%s %s %s\n%s",
			PROG_NAME_FULL,
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#else
"Version"
#endif
			,
			PROG_VERSION,
			PROG_COPYRIGHT
		    );
		    return(0);
		}
		/* No stdout dialog? */
		else if(!g_strcasecmp(arg, "--no-stdout-dialog") ||
			!g_strcasecmp(arg, "-no-stdout-dialog") ||
			!g_strcasecmp(arg, "--no_stdout_dialog") ||
			!g_strcasecmp(arg, "-no_stdout_dialog")
		)
		{ 
		    show_stdout_dialog = FALSE;
		}
		/* No stderr dialog? */
		else if(!g_strcasecmp(arg, "--no-stderr-dialog") ||
			!g_strcasecmp(arg, "-no-stderr-dialog") ||
			!g_strcasecmp(arg, "--no_stderr_dialog") ||
			!g_strcasecmp(arg, "-no_stderr_dialog")
		)
		{
		    show_stderr_dialog = FALSE;
		}
		/* Safe mode? */
		else if(!g_strcasecmp(arg, "--safe-mode") ||
			!g_strcasecmp(arg, "-safe-mode") ||
			!g_strcasecmp(arg, "--safe_mode") ||
			!g_strcasecmp(arg, "-safe_mode") ||
			!g_strcasecmp(arg, "--safe") ||
			!g_strcasecmp(arg, "-safe")
		)
		{
		    safe_mode = TRUE;
		    show_stdout_dialog = FALSE;
		    show_stderr_dialog = FALSE;
		}
	    }
	}

	/* Set up the UNIX signal callbacks */
#ifdef SIGHUP
	signal(SIGHUP, EDVSignalCB);
#endif
#ifdef SIGINT
	signal(SIGINT, EDVSignalCB);
#endif
#ifdef SIGTERM
	signal(SIGTERM, EDVSignalCB);
#endif
#ifdef SIGQUIT
	signal(SIGQUIT, EDVSignalCB);
#endif
#ifdef SIGSEGV
	signal(SIGSEGV, EDVSignalCB);
#endif
#ifdef SIGUSR1
	signal(SIGUSR1, EDVSignalCB);
#endif
#ifdef SIGUSR2
	signal(SIGUSR2, EDVSignalCB);
#endif
#ifdef SIGPIPE
	signal(SIGPIPE, EDVSignalCB);
#endif


	/* Check if the GTK library version is 1.2.10 or newer, if
	 * not then print warning
	 */
	s = gtk_check_version(1, 2, 10);
	if(!STRISEMPTY(s))
	    g_printerr("%s\n", s);

	/* Need to initialize GTK? */
	if(!initialized_gtk)
	{
	    /* Set the GTK locale */
	    gtk_set_locale();

	    /* Initialize GTK */
	    if(!gtk_init_check(&argc, &argv))
	    {
		g_printerr("Unable to initialize GTK.\n");
		return(1);
	    }

	    /* Initialize the GDK RGB Buffers */
	    gdk_rgb_init();

	    initialized_gtk = TRUE;
	}

	/* Initialize the dialogs */
	ConMsgInit(
	    PROG_NAME_FULL,
	    NULL,
	    0,
	    0,
	    show_stdout_dialog,
	    show_stderr_dialog
	);
	FPromptInit();
	if(safe_mode)
	    FPromptSetShadowStyle(FPROMPT_SHADOW_NONE);
	CDialogInit();
	ProgressDialogInit();
	FileBrowserInit();
	CSDInit();
	FSDInit();
	PDialogInit();

	/* Create the core */
	edv_core = core = EDVNew(argc, argv, &err_rtn);
	if(core == NULL)
	    return((err_rtn < 0) ? -err_rtn : err_rtn);

	/* Set the file selector callbacks */
	FileBrowserSetObjectCreatedCB(EDVFileSelectorObjectCreatedCB, core);
	FileBrowserSetObjectModifiedCB(EDVFileSelectorObjectModifiedCB, core);
	FileBrowserSetObjectDeletedCB(EDVFileSelectorObjectDeletedCB, core);

	/* Push the first GTK main loop */
	gtk_main();

	/* Save the configuration and then delete the core */
	edv_core = NULL;		/* Unset the global core marker first */
	EDVDelete(
	    core,
	    TRUE			/* Save configuration */
	);
	core = NULL;

	/* Shutdown the dialogs */
	FSDShutdown();
	CSDShutdown();
	PDialogShutdown();
	FileBrowserShutdown();
	ProgressDialogShutdown();
	CDialogShutdown();
	FPromptShutdown();
	ConMsgShutdown();

	return(0);
}
