#include <glib.h>
#include "edv_id.h"


/* UID */
edv_uid_struct *EDVUIDNew(void);
void EDVUIDDelete(edv_uid_struct *uid);

/* GID */
edv_gid_struct *EDVGIDNew(void);
void EDVGIDDelete(edv_gid_struct *gid);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates a new UID.
 */
edv_uid_struct *EDVUIDNew(void)
{
	return(EDV_UID(g_malloc0(sizeof(edv_uid_struct))));
}

/*
 *	Deletes the UID.
 */
void EDVUIDDelete(edv_uid_struct *uid)
{
	if(uid == NULL)
	    return;

	g_free(uid->name);
	g_free(uid->password);

	g_free(uid->government_name);
	g_free(uid->home_directory);
	g_free(uid->shell_program);

	g_free(uid);
}


/*
 *	Creates a new GID.
 */
edv_gid_struct *EDVGIDNew(void)
{
	return(EDV_GID(g_malloc0(sizeof(edv_gid_struct))));
}

/*
 *	Deletes the GID.
 */
void EDVGIDDelete(edv_gid_struct *gid)
{
	if(gid == NULL)
	    return;

	g_free(gid->name);
	g_free(gid->password);
	if(gid->group_members_list != NULL)
	{
	    g_list_foreach(gid->group_members_list, (GFunc)g_free, NULL);
	    g_list_free(gid->group_members_list);
	}
	g_free(gid);
}
