/*
                            History Window
 */

#ifndef HISTORY_WIN_H
#define HISTORY_WIN_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "edv_history.h"


typedef struct _edv_history_win_struct	edv_history_win_struct;
#define EDV_HISTORY_WIN(p)		((edv_history_win_struct *)(p))


/*
 *	Flags:
 */
typedef enum {
	EDV_HISTORY_WIN_SHOW_DETAILS	= (1 << 0)
} edv_history_win_flags;


/*
 *	Cell Styles:
 */
typedef enum {
	EDV_HISTORY_CELL_STYLE_SUCCESS,
	EDV_HISTORY_CELL_STYLE_ERROR,		/* General/system/ambiguous */
	EDV_HISTORY_CELL_STYLE_CANCEL		/* Cancel/no/abort */
} edv_history_win_cell_style;
#define EDV_HISTORY_TOTAL_CELL_STYLES	3


/*
 *	History Window:
 */
struct _edv_history_win_struct {

        GtkWidget	*toplevel;
        GtkAccelGroup	*accelgrp;
        gboolean	processing;
        gint		busy_count,
			freeze_count;
	edv_core_struct	*core;

	edv_history_win_flags	flags;

	GtkWidget	*main_vbox,
			*find_entry,
			*history_clist,
			*refresh_btn,
			*details_btn,
			*clear_btn,
			*details_separator,
			*details_parent,	/* GtkVBox */
			*details_client,	/* Parented to display_parent */
			*close_btn;

	/* Right click menu */
	GtkWidget	*menu,
			*refresh_mi,
			*save_as_mi,
			*clear_mi;

	/* Pixmap and mask pairs used for operation icons */
	GdkPixmap	*other_operation_pixmap;
	GdkBitmap	*other_operation_mask;

	GdkPixmap	*recycle_bin_pixmap;
	GdkBitmap	*recycle_bin_mask;

	GdkPixmap	*object_create_pixmap;
	GdkBitmap	*object_create_mask;
	GdkPixmap	*object_copy_pixmap;
	GdkBitmap	*object_copy_mask;
	GdkPixmap	*object_move_pixmap;
	GdkBitmap	*object_move_mask;
	GdkPixmap	*object_link_pixmap;
	GdkBitmap	*object_link_mask;
	GdkPixmap	*object_chown_pixmap;
	GdkBitmap	*object_chown_mask;
	GdkPixmap	*object_chmod_pixmap;
	GdkBitmap	*object_chmod_mask;
	GdkPixmap	*object_chtime_pixmap;
	GdkBitmap	*object_chtime_mask;
	GdkPixmap	*object_download_pixmap;
	GdkBitmap	*object_download_mask;
	GdkPixmap	*object_delete_pixmap;
	GdkBitmap	*object_delete_mask;

	GdkPixmap	*recobj_recover_pixmap;
	GdkBitmap	*recobj_recover_mask;
	GdkPixmap	*recobj_purge_pixmap;
	GdkBitmap	*recobj_purge_mask;

	GdkPixmap	*arcobj_add_pixmap;
	GdkBitmap	*arcobj_add_mask;
	GdkPixmap	*arcobj_extract_pixmap;
	GdkBitmap	*arcobj_extract_mask;
	GdkPixmap	*arcobj_delete_pixmap;
	GdkBitmap	*arcobj_delete_mask;
	GdkPixmap	*archive_fix_pixmap;
	GdkBitmap	*archive_fix_mask;

	GdkPixmap	*object_other_small_pixmap;
	GdkBitmap	*object_other_small_mask;
	GdkPixmap	*object_other_medium_pixmap;
	GdkBitmap	*object_other_medium_mask;

	GdkPixmap	*error_small_pixmap;
	GdkBitmap	*error_small_mask;
	GdkPixmap	*error_medium_pixmap;
	GdkBitmap	*error_medium_mask;

	/* Styles for directory_ctree and contents_clist cells */
	GtkStyle	*cell_style[EDV_HISTORY_TOTAL_CELL_STYLES];

};


/* Callbacks */
extern void EDVHistoryWinWriteProtectChangedCB(
	edv_history_win_struct *lw, const gboolean state
);
extern void EDVHistoryWinHistoryAddedCB(
	edv_history_win_struct *lw,
	const gint h_num, edv_history_struct *h
);
extern void EDVHistoryWinHistoryRemovedCB(
	edv_history_win_struct *lw,
	const gint h_num
);
extern void EDVHistoryWinReconfiguredNotifyCB(
	edv_history_win_struct *lw
);

/* Operations */
extern void EDVHistoryWinClear(
        edv_core_struct *core,
        edv_history_win_struct *lw,
        GtkWidget *toplevel
);
extern void EDVHistoryWinSaveAs(edv_history_win_struct *lw);

/* Update List */
extern void EDVHistoryWinUpdateList(edv_history_win_struct *lw);

/* Update Details */
extern void EDVHistoryWinUpdateDetails(
	edv_history_win_struct *lw,
	edv_history_struct *h
);

/* Sync Configuration */
extern void EDVHistoryWinSyncConfiguration(edv_history_win_struct *lw);

/* Styles Regenerate */
extern void EDVHistoryWinListStylesRegenerate(edv_history_win_struct *lw);

/* History Window */
extern edv_history_win_struct *EDVHistoryWinNew(edv_core_struct *core);
extern void EDVHistoryWinShowDetails(
        edv_history_win_struct *lw,
        const gboolean show
);
extern void EDVHistoryWinUpdateMenus(edv_history_win_struct *lw);
extern void EDVHistoryWinSetBusy(edv_history_win_struct *lw, const gboolean busy);
extern gboolean EDVHistoryWinIsMapped(edv_history_win_struct *lw);
extern void EDVHistoryWinMap(edv_history_win_struct *lw);
extern void EDVHistoryWinUnmap(edv_history_win_struct *lw);
extern void EDVHistoryWinDelete(edv_history_win_struct *lw);


#endif	/* HISTORY_WIN_H */
