/*
				 MIME Types List
 */

#ifndef EDV_MIME_TYPES_LIST_H
#define EDV_MIME_TYPES_LIST_H

#include <glib.h>
#include "edv_mime_type.h"


/* Matching */
extern edv_mime_type_struct *EDVMimeTypesListMatchType(
	edv_mime_type_struct **list, const gint total,
	gint *n,
	const gchar *type, const gboolean case_sensitive
);
extern edv_mime_type_struct *EDVMimeTypesListMatchPath(
	edv_mime_type_struct **list, const gint total,
	const gchar *path
);

/* Insert, Append, Remove */
extern gint EDVMimeTypesListInsert(
	edv_mime_type_struct ***list, gint *total,
	const gint i,
	edv_mime_type_struct *m
);
extern gint EDVMimeTypesListAppend(
	edv_mime_type_struct ***list, gint *total,
	edv_mime_type_struct *m
);
extern void EDVMimeTypesListRemove(
	edv_mime_type_struct ***list, gint *total,
	const gint i
);
extern void EDVMimeTypesListClear(
	edv_mime_type_struct ***list, gint *total
);

/* DDE Buffer */
extern GList *EDVMimeTypesListFromDDEBuffer(
	edv_mime_type_struct **list, const gint total,
	const guint8 *buf, const gint buf_len
);
extern guint8 *EDVMimeTypesListToDDEBuffer(
	edv_mime_type_struct **list, const gint total,
	GList *selection_list,
	gint *buf_len_rtn
);
extern GList *EDVMimeTypeCommandsListFromDDEBuffer(
	const guint8 *buf, const gint buf_len
);
extern guint8 *EDVMimeTypeCommandsListToDDEBuffer(
	GList *commands_list,
	gint *buf_len_rtn
);

/* Mailcap format import/export */
extern void EDVMimeTypesListMailcapImport(
	const gchar *path,
	edv_mime_type_struct ***list, gint *total,
	const gint insert_index,
	const gboolean update, const gboolean only_newer,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data,
	void (*added_cb)(const gint, edv_mime_type_struct *, gpointer),
	gpointer added_data,
	void (*modified_cb)(const gint, edv_mime_type_struct *, gpointer),
	gpointer modified_data
);
extern void EDVMimeTypesListMailcapExport(
	const gchar *path,
	edv_mime_type_struct **list, const gint total,
	const gboolean include_read_only,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data
);

/* Media Types format import/export */
extern void EDVMimeTypesListMediaTypesImport(
	const gchar *path,
	edv_mime_type_struct ***list, gint *total,
	const gint insert_index,
	const gboolean update, const gboolean only_newer,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data,
	void (*added_cb)(const gint, edv_mime_type_struct *, gpointer),
	gpointer added_data,
	void (*modified_cb)(const gint, edv_mime_type_struct *, gpointer),
	gpointer modified_data
);
extern void EDVMimeTypesListMediaTypesExport(
	const gchar *path,
	edv_mime_type_struct **list, const gint total,
	const gboolean include_read_only,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data
);

/* Endeavour MIME Types format reading and writing */
extern void EDVMimeTypesListSystemFileOpen(
	const gchar *data_path,
	edv_mime_type_struct ***list, gint *total,
	const gint insert_index,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data,
	void (*added_cb)(const gint, edv_mime_type_struct *, gpointer),
	gpointer added_data,
	const gboolean mark_all_loaded_read_only
);
extern void EDVMimeTypesListFileOpen(
	const gchar *path,
	edv_mime_type_struct ***list, gint *total,
	const gint insert_index,
	const gboolean update, const gboolean only_newer,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data,
	void (*added_cb)(const gint, edv_mime_type_struct *, gpointer),
	gpointer added_data,
	void (*modified_cb)(const gint, edv_mime_type_struct *, gpointer),
	gpointer modified_data,
	const gboolean mark_all_loaded_read_only
);
extern void EDVMimeTypesListFileSave(
	const gchar *path,
	edv_mime_type_struct **list, const gint total,
	const gboolean include_read_only,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data
);


#endif	/* EDV_MIME_TYPE_FIO_H */
