#include <glib.h>

#include "edv_history.h"


edv_history_struct *EDVHistoryNew(void);
edv_history_struct *EDVHistoryCopy(const edv_history_struct *h);
void EDVHistoryDelete(edv_history_struct *h);

void EDVHistorySetValues(
	edv_history_struct *h,
	const edv_history_type type,
	const gulong time_start,	/* In systime seconds */
	const gulong time_end,		/* In systime seconds */
	const gint status,      
	const gchar *src_path,		/* Source */
	const gchar *tar_path,		/* Target */
	const gchar *comments
);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates a new history item.
 */
edv_history_struct *EDVHistoryNew(void)
{
	return(EDV_HISTORY(
	    g_malloc0(sizeof(edv_history_struct))
	));
}

/*
 *	Coppies a history item
 */
edv_history_struct *EDVHistoryCopy(const edv_history_struct *h)
{
	const edv_history_struct *src = h;
	edv_history_struct *tar;

	if(src == NULL)
	    return(NULL);

	tar = EDVHistoryNew();
	if(tar == NULL)
	    return(NULL);

	tar->type = src->type;

	tar->time_start = src->time_start;
	tar->time_end = src->time_end;

	tar->status = src->status;

	tar->src_path = STRDUP(src->src_path);
	tar->tar_path = STRDUP(src->tar_path);

	tar->comments = STRDUP(src->comments);

	return(tar);
}

/*
 *	Deletes the history item
 */
void EDVHistoryDelete(edv_history_struct *h)
{
	if(h == NULL)
	    return;

	g_free(h->src_path);
	g_free(h->tar_path);
	g_free(h->comments);
	g_free(h);
}


/*
 *	Sets the given values to the given history item.
 */
void EDVHistorySetValues(
	edv_history_struct *h,
	const edv_history_type type,
	const gulong time_start,	/* In systime seconds */
	const gulong time_end,		/* In systime seconds */
	const gint status,      
	const gchar *src_path,		/* Source */
	const gchar *tar_path,		/* Target */
	const gchar *comments
)
{
	if(h == NULL)
	    return;

	h->type = type;

	h->time_start = time_start;
	h->time_end = time_end;

	h->status = status;

	g_free(h->src_path);
	h->src_path = STRDUP(src_path);

	g_free(h->tar_path);
	h->tar_path = STRDUP(tar_path);

	g_free(h->comments);
	h->comments = STRDUP(comments);
}
