/*
		      Endeavour Browser Callbacks
 */

#ifndef BROWSER_CB_H
#define BROWSER_CB_H

#include <sys/stat.h>
#include <gtk/gtk.h>
#include "edv_device.h"
#include "edv_mime_type.h"
#include "stacklist.h"
#include "browser.h"


/* GTK+ Signal Callbacks */
extern void EDVBrowserCmdDestroyCB(gpointer data);
extern void EDVBrowserContentsItemDestroyCB(gpointer data);
extern void EDVBrowserDirTreeItemDestroyCB(gpointer data);

extern gint EDVBrowserDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint EDVBrowserKeyEventCB(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint EDVBrowserButtonPressEventCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void EDVBrowserHandleChildAttachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void EDVBrowserHandleChildDetachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void EDVBrowserTreeSelectRowCB(
	GtkCTree *ctree, GtkCTreeNode *node, gint column,
	gpointer data
);
extern void EDVBrowserTreeUnselectRowCB(
	GtkCTree *ctree, GtkCTreeNode *node, gint column,
	gpointer data
);
extern void EDVBrowserTreeExpandCB(
	GtkCTree *ctree, GtkCTreeNode *node, gpointer data
);
extern void EDVBrowserTreeCollapseCB(
	GtkCTree *ctree, GtkCTreeNode *node, gpointer data
);

extern void EDVBrowserResizeColumnCB(
	GtkCList *clist, gint column, gint width, gpointer data
);
extern void EDVBrowserClickColumnCB(
	GtkCList *clist, gint column, gpointer data
);
extern void EDVBrowserSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
extern void EDVBrowserUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

extern void EDVBrowserComboActivateCB(GtkWidget *widget, gpointer data);

/* Menu Item Callbacks */
extern void EDVBrowserMenuItemCB(GtkWidget *widget, gpointer data);
extern gint EDVBrowserMenuItemEnterCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVBrowserMenuItemLeaveCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern void EDVBrowserMenuItemCmdObjectOpCB(GtkWidget *widget, gpointer data);
extern void EDVBrowserMenuItemCmdNewObjectCB(GtkWidget *widget, gpointer data);
extern gint EDVBrowserMenuItemCmdEnterCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVBrowserMenuItemCmdLeaveCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

/* Paths List Get Callback */
extern GList *EDVBrowserGetSelectedPathsListCB(gpointer data);

/* Go To Directory Callback */
extern void EDVBrowserGotoDirectoryCB(gpointer data, const gchar *path);

/* Mount Bar Callbacks */
extern void EDVBrowserMountBarMountCB(
	edv_mount_bar_struct *mb, gint dev_num, edv_device_struct *dev,
	gpointer data
);
extern void EDVBrowserMountBarEjectCB(
	edv_mount_bar_struct *mb, gint dev_num, edv_device_struct *dev,
	gpointer data
);
extern void EDVBrowserMountBarGoToCB(
	edv_mount_bar_struct *mb, gint dev_num, edv_device_struct *dev,
	gpointer data
);

/* Find Bar Callbacks */
extern const gchar *EDVBrowserFindBarLocationCB(
	edv_find_bar_struct *fb,
	gpointer data
);
extern void EDVBrowserFindBarStartCB(
	edv_find_bar_struct *fb,
	gpointer data
);
extern void EDVBrowserFindBarEndCB(
	edv_find_bar_struct *fb,
	const gint nmatches,
	gpointer data
);
extern void EDVBrowserFindBarMatchCB(
	const gchar *path,
	struct stat *lstat_buf,
	const gchar *excerpt,
	const gint line_index,
	gpointer data
);

/* Status Bar Callbacks */
extern void EDVBrowserStatusMessageCB(const gchar *message, gpointer data);
extern void EDVBrowserStatusProgressCB(const gfloat progress, gpointer data);

/* Write Protect Changed Callback */
extern void EDVBrowserWriteProtectChangedCB(
	edv_browser_struct *browser, const gboolean state
);

/* Object Callbacks */
extern void EDVBrowserObjectAddedNotifyCB(
	edv_browser_struct *browser, const gchar *path,
	struct stat *lstat_buf
);
extern void EDVBrowserObjectModifiedNotifyCB(
	edv_browser_struct *browser, const gchar *path,
	const gchar *new_path,
	struct stat *lstat_buf
);
extern void EDVBrowserObjectRemovedNotifyCB(
	edv_browser_struct *browser, const gchar *path
);

/* Mount/Unmount Callback */
extern void EDVBrowserMountNotifyCB(
	edv_browser_struct *browser,
	const gint dev_num, edv_device_struct *dev,
	const gboolean is_mounted
);

/* Recycled Object Callbacks */
extern void EDVBrowserRecycledObjectAddedNotifyCB(
	edv_browser_struct *browser, const guint index
);
extern void EDVBrowserRecycledObjectModifiedNotifyCB(
	edv_browser_struct *browser, const guint index
);
extern void EDVBrowserRecycledObjectRemovedNotifyCB(
	edv_browser_struct *browser, const guint index
);

/* Reconfigured Callback */
extern void EDVBrowserReconfiguredNotifyCB(edv_browser_struct *browser);

/* MIME Type Callbacks */
extern void EDVBrowserMimeTypeAddedCB(
	edv_browser_struct *browser,
	const gint mt_num, edv_mime_type_struct *mt
);
extern void EDVBrowserMimeTypeModifiedCB(
	edv_browser_struct *browser,
	const gint mt_num, edv_mime_type_struct *mt
);
extern void EDVBrowserMimeTypeRemovedCB(
	edv_browser_struct *browser,
	const gint mt_num
);

/* Device Callbacks */
extern void EDVBrowserDeviceAddedCB(
	edv_browser_struct *browser,
	const gint dev_num, edv_device_struct *dev
);
extern void EDVBrowserDeviceModifiedCB(
	edv_browser_struct *browser,
	const gint dev_num, edv_device_struct *dev
);
extern void EDVBrowserDeviceRemovedCB(
	edv_browser_struct *browser,
	const gint dev_num
);


#endif	/* BROWSER_CB_H */
