/*
	Demo for Endeavour interprocess command sending (no GTK or GUI
	code involved).
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <glib.h>
#include "../../include/disk.h"
#include "../cfg.h"
#include "../cfg_fio.h"
#define NEED_EDV_CFG_LIST_SOURCE
#include "../edv_cfg_list.h"
#include "../edv_utils.h"
#include "../edv_interps.h"
#include "../config.h"


static gint SendCommand(
	cfg_item_struct *cfg_list,
	gchar **cmdv
);

#ifdef PROG_USAGE_MESG
# undef PROG_USAGE_MESG
#endif
#define PROG_USAGE_MESG	"\
Usage: sendcmd <cmd1> [cmd2] [cmd3] [cmd4...]\n\
\n\
    Typical values for <cmd#> are as follows:\n\
\n\
	\"new_window file_browser <path>\"\n\
	\"new_window image_browser <path>\"\n\
	\"new_window archiver <path>\"\n\
	\"new_window recycle_bin\"\n\
	\"new_window properties <path>\"\n\
	\"new_window options\"\n\
	\"new_window customize\"\n\
	\"new_window devices\"\n\
	\"new_window mimetypes\"\n\
	\"new_window run_dialog\"\n\
\n\
    Remember to put \" characters around each <cmd#>.\n\
\n"


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


static gint SendCommand(
	cfg_item_struct *cfg_list,
	gchar **cmdv
)
{
	const gint p = EDVInterPSGetLock(cfg_list);
	if(p == 0)
	{
	    g_printerr(
"Endeavour is not running or no lock link found.\n"
	    );
	    return(-2);
	}

	EDVInterPSSendCommandsList(cfg_list, p, cmdv);

	return(0);
}

int main(int argc, char *argv[])
{
	gint i, ncmds;
	const gchar *s, *arg;
	gchar *cfg_file, **cmds_list;
	cfg_item_struct cfg_list[] = EDV_CONFIGURATION_LIST;

	/* Get value of environment variable HOME and prefix it to
	 * the standard path to the local recycled objects index file
	 * to obtain it's path as recycled_index_file
	 */
	s = getenv("HOME");
	if(s == NULL)
	    s = "/";
	cfg_file = STRDUP(PrefixPaths(s, ".endeavour2/endeavour2.ini"));

	/* If no arguments then print help */
	if(argc < 2)
	{
	    g_print("%s", PROG_USAGE_MESG);
	    g_free(cfg_file);
	    return(0);
	}

	/* Begin parsing the arguments */
	arg = argv[1];

	/* Help? */
	if(!g_strcasecmp(arg, "--help") ||
	   !g_strcasecmp(arg, "-help") ||
	   !g_strcasecmp(arg, "--h") ||
	   !g_strcasecmp(arg, "-h") ||
	   !g_strcasecmp(arg, "-?")
	)
	{
	    g_print("%s", PROG_USAGE_MESG);
	    g_free(cfg_file);
	    return(0);
	}
	/* Version? */
	else if(!g_strcasecmp(arg, "--version") ||
	        !g_strcasecmp(arg, "-version")
	)
	{
	    g_print(
		"%s",
PROG_NAME " Send Command " PROG_VERSION "\n" PROG_COPYRIGHT
	    );
	    g_free(cfg_file);
	    return(0);
	}

	/* Get the configuration */
	CFGFileOpen(cfg_file, cfg_list);

	/* Format the commands list from the arguments and send out
	 * the commands
	 */
	ncmds = argc - 1;
	cmds_list = (gchar **)g_malloc((ncmds + 1) * sizeof(gchar *));
	if(cmds_list != NULL)
	{
	    for(i = 0; i < ncmds; i++)
		cmds_list[i] = STRDUP(argv[i + 1]);
	    cmds_list[ncmds] = NULL;

	    SendCommand(cfg_list, cmds_list);

	    g_strfreev(cmds_list);
	}

	g_free(cfg_file);

	return(0);
}
