#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "guiutils.h"
#include "toolbar.h"

#include "cfg.h"
#include "edv_types.h"
#include "edv_list_cb.h"
#include "edv_status_bar.h"
#include "recbin.h"
#include "recbin_cb.h"
#include "recbin_op_cb.h"
#include "recbin_contents_list.h"
#include "recbin_dnd.h"
#include "endeavour2.h"
#include "edv_cb.h"
#include "edv_utils.h"
#include "edv_utils_gtk.h"
#include "edv_cfg_list.h"
#include "config.h"

#include "images/icon_hsep_20x20.xpm"
#include "images/icon_save_20x20.xpm"
#include "images/icon_trace_20x20.xpm"
#include "images/icon_run_20x20.xpm"
#include "images/icon_terminal2_20x20.xpm"
#include "images/icon_close_20x20.xpm"
#include "images/icon_exit_20x20.xpm"
#include "images/icon_recover_20x20.xpm"
#include "images/icon_purge_20x20.xpm"
#include "images/icon_purge_all_20x20.xpm"
#include "images/icon_select_all_20x20.xpm"
#include "images/icon_unselect_all_20x20.xpm"
#include "images/icon_invert_selection_20x20.xpm"
#include "images/icon_reload_20x20.xpm"
#include "images/icon_mimetypes_20x20.xpm"
#include "images/icon_search_20x20.xpm"
#include "images/icon_tool_bar_20x20.xpm"
#include "images/icon_status_bar_20x20.xpm"
#include "images/icon_wildcards_20x20.xpm"
#include "images/icon_options2_20x20.xpm"
#include "images/icon_customize_20x20.xpm"
#include "images/icon_insecure_20x20.xpm"
#include "images/icon_secure_20x20.xpm"
#include "images/icon_help_20x20.xpm"
#include "images/icon_about_20x20.xpm"

#include "images/endeavour_20x20.xpm"
#include "images/image_browser_20x20.xpm"
#include "images/archiver_20x20.xpm"
#include "images/icon_trash_20x20.xpm"
#include "images/icon_trash_empty_20x20.xpm"

#include "images/icon_trash_empty_48x48.xpm"
#include "images/icon_trash_48x48.xpm"


/* Utilities */
edv_recbin_opid_struct *EDVRecBinMatchOPID(
	edv_recbin_struct *recbin, edv_recbin_op op
);

/* Title */
void EDVRecBinSetTitle(edv_recbin_struct *recbin);

/* Regenerate Style, Menus, and Tool Bar */
void EDVRecBinAccelkeysRegenerate(edv_recbin_struct *recbin);
void EDVRecBinToolBarRegenerate(edv_recbin_struct *recbin);
void EDVRecBinContentsMenuRegenerate(edv_recbin_struct *recbin);

/* Sync Configuration */
void EDVRecBinSyncConfiguration(edv_recbin_struct *recbin);

/* Operation IDs */
GList *EDVRecBinOPIDListNew(edv_recbin_struct *recbin);
void EDVRecBinOPIDListDelete(GList *glist);

/* Accel Keys */
cfg_accelkey_list_struct *EDVRecBinAccelkeysListNewDefault(void);

/* Recycle Bin */
static void EDVRecBinCreateMenuBar(
	edv_recbin_struct *recbin, GtkWidget *parent
);
edv_recbin_struct *EDVRecBinNew(edv_core_struct *core);
void EDVRecBinSyncData(edv_recbin_struct *recbin);
void EDVRecBinUpdateMenus(edv_recbin_struct *recbin);
void EDVRecBinUpdateContentsHeadings(
	edv_recbin_struct *recbin,
	const gint *contents_heading, gint total_contents_headings
);
void EDVRecBinSetBusy(edv_recbin_struct *recbin, gboolean busy);
gboolean EDVRecBinIsMapped(edv_recbin_struct *recbin);
void EDVRecBinMap(edv_recbin_struct *recbin);
void EDVRecBinUnmap(edv_recbin_struct *recbin);
void EDVRecBinDelete(edv_recbin_struct *recbin);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Returns the Recycle Bin Operation ID that matches the given
 *	operation.
 */
edv_recbin_opid_struct *EDVRecBinMatchOPID(
	edv_recbin_struct *recbin, edv_recbin_op op
)
{
	GList *glist;
	edv_recbin_opid_struct *opid;

	if(recbin == NULL)
	    return(NULL);

	for(glist = recbin->opid_list;
	    glist != NULL;
	    glist = g_list_next(glist)
	)
	{
	    opid = EDV_RECBIN_OPID(glist->data);
	    if(opid == NULL)
		continue;

	    if(opid->op == op)
		return(opid);
	}

	return(NULL);
}


/*
 *	Sets the Recycle Bin title.
 */
void EDVRecBinSetTitle(edv_recbin_struct *recbin)
{
	gboolean include_user_name;
#if defined(PROG_LANGUAGE_FRENCH)
	const gchar *prog_name = "Corbeille";
#else
	const gchar *prog_name = "Recycle Bin";
#endif
	gchar *title;
	GtkWidget *w;
	const cfg_item_struct *cfg_list;
	edv_core_struct *core;

	if(recbin == NULL)
	    return;

	core = recbin->core;
	if(core == NULL)
	    return;

	cfg_list = core->cfg_list;

	if(!STRISEMPTY(core->title))
	    prog_name = core->title;

	w = recbin->toplevel;
	if(w == NULL)
	    return;

	include_user_name = EDV_GET_B(EDV_CFG_PARM_RECBIN_TITLE_WITH_USER);

	/* Generate new title string */
	if(include_user_name)
	    title = g_strdup_printf(
		"%s: %s",
		prog_name, core->effective_user_id_host_str
	    );
	else
	    title = STRDUP(prog_name);

	/* Set new title */
	gtk_window_set_title(GTK_WINDOW(w), title);

	g_free(title);
}


/*
 *	Resets the Recycle Bin's accelkeys displayed on the widgets.
 */
void EDVRecBinAccelkeysRegenerate(edv_recbin_struct *recbin)
{
	GtkAccelGroup *accelgrp = NULL; 
	cfg_accelkey_list_struct *ak_list;
	const cfg_item_struct *cfg_list;
	edv_core_struct *core;

	if(recbin == NULL)
	    return;
		   
	core = recbin->core;
	if(core == NULL)
	    return;

	cfg_list = core->cfg_list;

	ak_list = EDV_GET_ACCELKEY_LIST(EDV_CFG_PARM_RECBIN_ACCELERATOR_KEYS);
	if(ak_list == NULL)                                                    
	    return;

#define UPDATE_ACCELKEY(_w_,_opid_)	{	\
 if(((_w_) != NULL) && ((_opid_) > 0)) {	\
  GList *glist;					\
  cfg_accelkey_struct *ak;			\
						\
  for(glist = ak_list->list;			\
      glist != NULL;				\
      glist = g_list_next(glist)		\
  ) {						\
   ak = CFG_ACCELKEY(glist->data);		\
   if(ak == NULL)				\
    continue;					\
						\
   if(ak->opid == (gint)(_opid_)) {		\
    GUIMenuItemSetAccelKey(			\
     (_w_), accelgrp, ak->key, ak->modifiers	\
    );						\
    break;					\
   }						\
  }						\
 }						\
}

	UPDATE_ACCELKEY(
	    recbin->recover_mi,
	    EDV_RECBIN_OP_RECOVER
	);
	UPDATE_ACCELKEY(
	    recbin->purge_mi,
	    EDV_RECBIN_OP_PURGE
	);
	UPDATE_ACCELKEY(
	    recbin->purge_all_mi,
	    EDV_RECBIN_OP_PURGE_ALL
	);
	UPDATE_ACCELKEY(
	    recbin->sync_recycle_bin_mi,
	    EDV_RECBIN_OP_SYNC_RECYCLE_BIN
	);
	UPDATE_ACCELKEY(
	    recbin->sync_disks_mi,
	    EDV_RECBIN_OP_SYNC_DISKS
	);
	UPDATE_ACCELKEY(
	    recbin->history_mi,
	    EDV_RECBIN_OP_HISTORY
	);
	UPDATE_ACCELKEY(
	    recbin->run_mi,
	    EDV_RECBIN_OP_RUN
	);
	UPDATE_ACCELKEY(
	    recbin->close_mi,
	    EDV_RECBIN_OP_CLOSE
	);

	UPDATE_ACCELKEY(
	    recbin->edit_recover_mi,
	    EDV_RECBIN_OP_RECOVER
	);
	UPDATE_ACCELKEY(
	    recbin->edit_purge_mi,
	    EDV_RECBIN_OP_PURGE
	);
	UPDATE_ACCELKEY(
	    recbin->edit_purge_all_mi,
	    EDV_RECBIN_OP_PURGE_ALL
	);
	UPDATE_ACCELKEY(
	    recbin->select_all_mi,
	    EDV_RECBIN_OP_SELECT_ALL
	);
	UPDATE_ACCELKEY(
	    recbin->unselect_all_mi,
	    EDV_RECBIN_OP_UNSELECT_ALL
	);
	UPDATE_ACCELKEY(
	    recbin->invert_selection_mi,
	    EDV_RECBIN_OP_INVERT_SELECTION
	);
	UPDATE_ACCELKEY(
	    recbin->find_mi,
	    EDV_RECBIN_OP_FIND
	);

	UPDATE_ACCELKEY(
	    recbin->refresh_mi,
	    EDV_RECBIN_OP_REFRESH
	);
	UPDATE_ACCELKEY(
	    recbin->refresh_all_mi,
	    EDV_RECBIN_OP_REFRESH_ALL
	);
	UPDATE_ACCELKEY(
	    recbin->show_tool_bar_micheck,
	    EDV_RECBIN_OP_SHOW_TOOL_BAR
	);
	UPDATE_ACCELKEY(
	    recbin->show_find_bar_micheck,
	    EDV_RECBIN_OP_SHOW_FIND_BAR
	);
	UPDATE_ACCELKEY(
	    recbin->show_status_bar_micheck,
	    EDV_RECBIN_OP_SHOW_STATUS_BAR
	);
	UPDATE_ACCELKEY(
	    recbin->contents_list_filter_mi,
	    EDV_RECBIN_OP_CONTENTS_LIST_FILTER
	);
	UPDATE_ACCELKEY(
	    recbin->mime_types_mi,
	    EDV_RECBIN_OP_MIME_TYPES
	);

	UPDATE_ACCELKEY(
	    recbin->write_protect_mi,
	    EDV_RECBIN_OP_WRITE_PROTECT
	);
	UPDATE_ACCELKEY(  
	    recbin->delete_method_recycle_micheck,
	    EDV_RECBIN_OP_DELETE_METHOD_RECYCLE
	);
	UPDATE_ACCELKEY(
	    recbin->delete_method_purge_micheck,
	    EDV_RECBIN_OP_DELETE_METHOD_PURGE
	);
	UPDATE_ACCELKEY(
	    recbin->options_mi,
	    EDV_RECBIN_OP_OPTIONS
	);
	UPDATE_ACCELKEY(
	    recbin->customize_mi,
	    EDV_RECBIN_OP_CUSTOMIZE
	);

	UPDATE_ACCELKEY(
	    recbin->window_new_browser_mi,
	    EDV_RECBIN_OP_NEW_BROWSER
	);
	UPDATE_ACCELKEY(
	    recbin->window_new_imbr_mi,
	    EDV_RECBIN_OP_NEW_IMBR
	);
	UPDATE_ACCELKEY(
	    recbin->window_new_archiver_mi,
	    EDV_RECBIN_OP_NEW_ARCHIVER
	);

	UPDATE_ACCELKEY(
	    recbin->help_contents_mi,
	    EDV_RECBIN_OP_HELP_CONTENTS
	);
	UPDATE_ACCELKEY(
	    recbin->help_recycle_bin_mi,
	    EDV_RECBIN_OP_HELP_RECYCLE_BIN
	);
	UPDATE_ACCELKEY(
	    recbin->help_keys_list_mi,
	    EDV_RECBIN_OP_HELP_KEYS_LIST
	);
	UPDATE_ACCELKEY(
	    recbin->help_common_operations_mi,
	    EDV_RECBIN_OP_HELP_COMMON_OPERATIONS
	);
	UPDATE_ACCELKEY(
	    recbin->help_about_mi,
	    EDV_RECBIN_OP_HELP_ABOUT
	);


	UPDATE_ACCELKEY(
	    recbin->contents_clist_recover_mi,
	    EDV_RECBIN_OP_RECOVER
	);
	UPDATE_ACCELKEY(
	    recbin->contents_clist_purge_mi,
	    EDV_RECBIN_OP_PURGE
	);
	UPDATE_ACCELKEY(
	    recbin->contents_clist_purge_all_mi,
	    EDV_RECBIN_OP_PURGE_ALL
	);

#undef UPDATE_ACCELKEY
}

/*
 *	Recreates the Recycle Bin's Tool Bar.
 */
void EDVRecBinToolBarRegenerate(edv_recbin_struct *recbin)
{
	GList *glist, *items_list;
	GtkWidget *parent;
	const cfg_intlist_struct *intlist;
	const cfg_item_struct *cfg_list;
	toolbar_display tb_display;
	toolbar_relief tb_relief;
	toolbar_struct *toolbar;
	toolbar_item_struct *item;
	edv_recbin_opid_struct *opid;
	edv_core_struct *core;

	if(recbin == NULL)
	    return;

	parent = recbin->tool_bar_handle;
	core = recbin->core;
	cfg_list = core->cfg_list;

	/* Get the Tool Bar configuration */
	tb_display = (toolbar_display)EDV_GET_I(
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY
	);
	tb_relief = (toolbar_relief)EDV_GET_I(
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF
	);
	intlist = EDV_GET_INTLIST(EDV_CFG_PARM_RECBIN_TOOL_BAR);
	if(intlist == NULL)
	    return;

	/* Delete the existing Tool Bar */
	ToolBarDelete(recbin->tool_bar);
	recbin->tool_bar = NULL;

	/* Create the Tool Bar items list */
	items_list = NULL;
	for(glist = intlist->list;
	    glist != NULL;
	    glist = g_list_next(glist)
	)
	{
	    /* Get the Operation ID */  
	    opid = EDVRecBinMatchOPID(
		recbin,
		(edv_recbin_op)glist->data
	    );
	    if(opid == NULL)
		continue;

	    switch(opid->op)
	    {
	      case EDV_RECBIN_OP_NONE:
		break;

	      default:
		item = ToolBarItemNew(
		    opid->tb_item_type,
		    NULL,
		    opid->button_name,
		    opid->button_icon_data,
		    opid->tooltip,
		    opid->op,
		    EDVRecBinOPCB, opid,
		    EDVRecBinOPEnterCB, opid,
		    EDVRecBinOPLeaveCB, opid
		);
		items_list = g_list_append(items_list, item);
		break;
	    }
	}

	/* Create the Tool Bar */
	recbin->tool_bar = toolbar = ToolBarNew(
	    parent,
	    items_list,
	    tb_display, tb_relief, FALSE
	);
	ToolBarMap(toolbar);

	/* Delete the Tool Bar items list */
	if(items_list != NULL)
	{
	    g_list_foreach(items_list, (GFunc)ToolBarItemDelete, NULL);
	    g_list_free(items_list);
	}
}

/*
 *	Recreates the Recycle Bin Contents List's right-click menu.
 */
void EDVRecBinContentsMenuRegenerate(edv_recbin_struct *recbin)
{
	guint8 **icon_data = NULL;
	edv_recbin_op op;
	GtkAccelGroup *accelgrp = NULL;
	GtkWidget *w, *menu;

	if(recbin == NULL)
	    return;

	/* Recreate menu */
	GTK_WIDGET_DESTROY(recbin->contents_clist_menu);
	recbin->contents_clist_menu = menu = GUIMenuCreate();

#define DO_ADD_MENU_ITEM_LABEL	{		\
 edv_recbin_opid_struct *opid =			\
  EDVRecBinMatchOPID(recbin, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (icon_data != NULL) ?			\
    icon_data : opid->menu_icon_data,		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods, NULL,	\
   opid, EDVRecBinMenuItemCB			\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVRecBinMenuItemEnterCB, opid,	\
   (gpointer)EDVRecBinMenuItemLeaveCB, opid	\
  );						\
 } else {					\
  w = NULL;					\
 }						\
}
#define DO_ADD_MENU_SEP		{		\
 w = GUIMenuItemCreate(				\
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,	\
  NULL, NULL, 0, 0, NULL,			\
  NULL, NULL					\
 );						\
}
	op = EDV_RECBIN_OP_RECOVER;
	DO_ADD_MENU_ITEM_LABEL
	GUISetMenuItemDefault(w);
	recbin->contents_clist_recover_mi = w;

	DO_ADD_MENU_SEP

	op = EDV_RECBIN_OP_PURGE;
	DO_ADD_MENU_ITEM_LABEL
	recbin->contents_clist_purge_mi = w;

	op = EDV_RECBIN_OP_PURGE_ALL;
	DO_ADD_MENU_ITEM_LABEL
	recbin->contents_clist_purge_all_mi = w;

#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP
}


/*
 *	Sets the Recycle Bin values to the configuration.
 */
void EDVRecBinSyncConfiguration(edv_recbin_struct *recbin)
{
	GtkWidget *w;
	edv_core_struct *core;
	cfg_item_struct *cfg_list;
	

	if(recbin == NULL)
	    return;

	core = recbin->core;
	if(core == NULL)
	    return;

	cfg_list = core->cfg_list;

	/* Toplevel geometry */
	w = recbin->toplevel;
	if(w != NULL)
	{
	    GdkWindow *window = w->window;
	    gint x = 0, y = 0;

	    if(window != NULL)
		gdk_window_get_root_origin(window, &x, &y);

	    EDV_SET_I(EDV_CFG_PARM_RECBIN_X, x);
	    EDV_SET_I(EDV_CFG_PARM_RECBIN_Y, y);
	    EDV_SET_I(EDV_CFG_PARM_RECBIN_WIDTH, w->allocation.width);
	    EDV_SET_I(EDV_CFG_PARM_RECBIN_HEIGHT, w->allocation.height);
	}

	/* EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN_WIDTH parameter is updated
	 * as they change in EDVRecBinResizeColumnCB() or when the
	 * configuration list is changed directly
	 */

	/* EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN parameter is updated
	 * when the configuration list is changed directly
	 */

	/* Contents list filter */
	if(STRISEMPTY(recbin->contents_list_filter))
	{
	    EDV_SET_S(
		EDV_CFG_PARM_RECBIN_CONTENTS_LIST_FILTER,
		"*"
	    );
	}
	else
	{
	    EDV_SET_S(
		EDV_CFG_PARM_RECBIN_CONTENTS_LIST_FILTER,
		recbin->contents_list_filter
	    );
	}
}


/*
 *	Creates a new Recycle Bin Operation IDs list.
 */
GList *EDVRecBinOPIDListNew(edv_recbin_struct *recbin)
{
	const gchar *button_name, *menu_name, *tooltip;
	guint accel_key, accel_mods;
	guint8 **button_icon_data, **menu_icon_data;
	GList *opid_list = NULL;
	toolbar_item_type tb_item_type;
	edv_opid_flags flags;
	edv_recbin_op op;
	edv_recbin_opid_struct *opid;
	void (*func_cb)(toolbar_item_struct *, gint, gpointer);
	void (*enter_func_cb)(toolbar_item_struct *, gint, gpointer);

#define DO_APPEND_OPID	{			\
 opid = EDV_RECBIN_OPID(			\
  g_malloc0(sizeof(edv_recbin_opid_struct))	\
 );						\
 if(opid != NULL) {				\
  opid->op = op;				\
  opid->flags = flags;				\
  opid->tb_item_type = tb_item_type;		\
  opid->func_cb = func_cb;			\
  opid->enter_func_cb = enter_func_cb;		\
  opid->button_name = STRDUP(button_name);	\
  opid->menu_name = STRDUP(menu_name);		\
  opid->tooltip = STRDUP(tooltip);		\
  opid->accel_key = accel_key;			\
  opid->accel_mods = accel_mods;		\
  opid->button_icon_data = button_icon_data;	\
  opid->menu_icon_data = menu_icon_data;	\
  opid->recbin = recbin;			\
  opid_list = g_list_append(opid_list, opid);	\
 }						\
}

	func_cb = EDVRecBinOPCB;
	enter_func_cb = EDVRecBinOPEnterCB;


	op = EDV_RECBIN_OP_SEPARATOR;
	flags = EDV_OPID_ALLOW_MULTIPLE | EDV_OPID_NO_OP;
	tb_item_type = TOOLBAR_ITEM_SEPARATOR;
	button_icon_data = (guint8 **)icon_hsep_20x20_xpm;
	menu_icon_data = button_icon_data;
#if defined(PROG_LANGUAGE_SPANISH)
	button_name = "Separador";
	menu_name = "Separador";
	tooltip = "Separador";
#elif defined(PROG_LANGUAGE_FRENCH)
	button_name = "Sparateur";
	menu_name = "Sparateur";
	tooltip = "Sparateur";
#elif defined(PROG_LANGUAGE_GERMAN)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#elif defined(PROG_LANGUAGE_ITALIAN)
	button_name = "Separatore";
	menu_name = "Separatore";
	tooltip = "Separatore";
#elif defined(PROG_LANGUAGE_DUTCH)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#elif defined(PROG_LANGUAGE_PORTUGUESE)
	button_name = "Separador";
	menu_name = "Separador";
	tooltip = "Separador";
#elif defined(PROG_LANGUAGE_NORWEGIAN)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#else
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_CLOSE;
	flags = 0;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	button_icon_data = (guint8 **)icon_close_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Close";
	menu_name = "Close";
	tooltip = "Close this window";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Cierre";
	menu_name = "Cierre";
	tooltip = "Cierre esta ventana";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Fermer";
	menu_name = "Fermer";
	tooltip = "Fermer cette fentre";
#endif
	accel_key = GDK_w;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_EXIT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_exit_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Exit";
	menu_name = "Exit";
	tooltip = "Close all windows in the application and exit";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Salida";
	menu_name = "La Salida";
	tooltip = "Cierra todas ventanas en la aplicacin y la";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Quitter";
	menu_name = "Quitter";
	tooltip = "Ferme toutes fentres dans l'application et sortie";
#endif
	accel_key = GDK_q;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_SYNC_DISKS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_save_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Sync Disks";
	menu_name = "Sync Disks";
	tooltip = "Flush any pending data transfers to disk";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Sincronizar Discos";
	menu_name = "Sincronizar Discos";
	tooltip = "Limpan cualquiera transferencias pendientes de datos al disco";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Synchro";
	menu_name = "Synchroniser Les Disques";
	tooltip = "Mettre  jour les transferts de donnes en attente au disque";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HISTORY;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_trace_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "History";
	menu_name = "History...";
	tooltip = "History of commands processed by this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Historia";
	menu_name = "La Historia...";
	tooltip = "La Historia de rdenes procesadas por esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Historique";
	menu_name = "Historique...";
	tooltip = "Historique des commandes traites par cette application";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_RUN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_run_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Run";
	menu_name = "Run...";
	tooltip = "Run a program";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Corra";
	menu_name = "Corra...";
	tooltip = "Corra un programa";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Excuter";
	menu_name = "Excuter...";
	tooltip = "Excute un programme";
#endif
	accel_key = GDK_r;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_RUN_TERMINAL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_terminal2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Terminal";
	menu_name = "Terminal";
	tooltip = "Run a terminal";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Terminal";
	menu_name = "La Terminal";
	tooltip = "Corre una terminal";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Terminal";
	menu_name = "Terminal";
	tooltip = "Ouvrir un terminal";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_WRITE_PROTECT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_secure_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Protect";
	menu_name = "Write Protect";
	tooltip = "Enable/disable write protect";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Proteja";
	menu_name = "Proteja contra escritura";
	tooltip = "Habilite/inhabilita la proteccion contra escritura";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Protge";
	menu_name = "Protge En criture";
	tooltip = "En-service/Hors-service la protection en criture";
#endif
	accel_key = GDK_y;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_DELETE_METHOD_RECYCLE;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_trash_20x20_xpm;
	menu_icon_data = button_icon_data;
	button_name = "Recycle";
	menu_name = "Delete Method: Recycle";
	tooltip = "Set the delete method to recycle";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID
		      
	op = EDV_RECBIN_OP_DELETE_METHOD_PURGE;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_purge_20x20_xpm;
	menu_icon_data = button_icon_data;
	button_name = "Purge";
	menu_name = "Delete Method: Purge";
	tooltip = "Set the delete method to purge";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_SYNC_RECYCLE_BIN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_trash_20x20_xpm;
	menu_icon_data = button_icon_data;
#if defined(PROG_LANGUAGE_SPANISH)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_FRENCH)
	button_name = "SynCorbeille";
	menu_name = "Compacte la Corbeille";
	tooltip = "Compacte la Corbeille et corrige toutes les erreurs";
#elif defined(PROG_LANGUAGE_GERMAN)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_ITALIAN)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_DUTCH)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_PORTUGUESE)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_NORWEGIAN)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#else
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_RECOVER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_recover_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Recover";
	menu_name = "Recover";
	tooltip = "Recover the selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Recupere";
	menu_name = "Recupere";
	tooltip = "Recupere objetos escogido(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Retrouver";
	menu_name = "Retrouver";
	tooltip = "Retrouve l'objet choisi(s)";
#endif
	accel_key = GDK_Return;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_PURGE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_purge_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Purge";
	menu_name = "Purge";
	tooltip = "Permanently discard the selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Purga";
	menu_name = "Purga";
	tooltip = "Tira Permanentemente objetos escogido(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Purge";
	menu_name = "Purge";
	tooltip = "D'Une faon permanente rejeter l'objet choisi(s)";
#endif
	accel_key = GDK_Delete;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_PURGE_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_purge_all_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Purge All";
	menu_name = "Purge All";
	tooltip = "Permanently discard all of the recycled objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "PurgTodo";
	menu_name = "Purgue Todo";
	tooltip = "Tira Permanentemente todo el contenido";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "PurgTout";
	menu_name = "Purger Tout";
	tooltip = "d'une faon permanente rejeter tous objets recycls";
#endif
	accel_key = GDK_Delete;
	accel_mods = GDK_SHIFT_MASK;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_SELECT_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_select_all_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "SelAll";
	menu_name = "Select All";
	tooltip = "Select all objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "SelAll";
	menu_name = "Escoja Todo";
	tooltip = "Escoge todo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "SelAll";
	menu_name = "Choisir Tout";
	tooltip = "Choisir tous objets";
#endif
	accel_key = GDK_a;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_UNSELECT_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_unselect_all_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "UnSelAll";
	menu_name = "Unselect All";
	tooltip = "Unselect all objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "UnSelAll";
	menu_name = "Unescoja Todo";
	tooltip = "Unescoge todo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "UnSelAll";
	menu_name = "Aucun";
	tooltip = "Aucun objets slects";
#endif
	accel_key = GDK_u;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_INVERT_SELECTION;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_invert_selection_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "InvSel";
	menu_name = "Invert Selection";
	tooltip =
 "Select all unselected objects and unselect all selected objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "InvSel";
	menu_name = "Invierta Seleccin";
	tooltip =
 "Selectos todos objetos y unselect no seleccionados todos objetos escogidos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "InvSel";
	menu_name = "Inverser Slection";
	tooltip = "Rejete tous les objets slections et slectionne les autres";

#endif
	accel_key = GDK_i;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_FIND;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_search_20x20_xpm;;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Find";
	menu_name = "Find...";
	tooltip = "Find object(s) by specific attributes";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Buscar";
	menu_name = "Buscar";
	tooltip = "Buscar objeto(s) por atributos especificados";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Find";
	menu_name = "Recherche";
	tooltip = "Recherche le objet(s) suivant les attributs spcifis ";
#endif
	accel_key = GDK_f;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_REFRESH;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_reload_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Refresh";
	menu_name = "Refresh";
	tooltip = "Refresh the recycled objects listing";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Refresque";
	menu_name = "Refresque";
	tooltip = "Refresque objetos de recycled que listan";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Rafrachir";
	menu_name = "Rafrachir";
	tooltip = "Rafrachit des objets recycls pour numrer";
#endif
	accel_key = GDK_F5;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_REFRESH_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_reload_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Refresh All";
	menu_name = "Refresh All";
	tooltip = "Refresh all listings";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Refresque Todo";
	menu_name = "Refresque Todo";
	tooltip = "Refresca todas listas";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Rafrachir Tout";
	menu_name = "Rafrachir Tout";
	tooltip = "Rafrachir toutes listes";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_SHOW_TOOL_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "Show/hide tool bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "La Exposicin/la barra de herramienta de cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Outils";
	menu_name = "Barre d'outils";
	tooltip = "Monter/cacher la barre d'outil";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_SHOW_FIND_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "Show/hide find bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "La exposicin/la barra del hallazgo del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Recherche";
	menu_name = "Barre de Recherche";
	tooltip = "Montrer/cacher la barre de Recherche";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_SHOW_STATUS_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_status_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "Show/hide status bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "La exposicin/la barra de la posicin del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Etat";
	menu_name = "Barre d'tat";
	tooltip = "monter/cacher la barre d'tat";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_CONTENTS_LIST_FILTER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_wildcards_20x20_xpm;
	menu_icon_data = button_icon_data;
	button_name = "Filter";
	menu_name = "Set Filter...";
	tooltip = "Set the name filter for listing objects";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_MIME_TYPES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_mimetypes_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "View/modify MIME Types";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "El panorama/modifica MIME Types";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "Voir/modifie MIME Types";
#endif
	accel_key = GDK_m;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_NEW_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)endeavour_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "FBrowser";
	menu_name = "New File Browser";
	tooltip = "Create a new file browser";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FBrowser";
	menu_name = "Nuevo Examinador De Archivos";
	tooltip = "Muestra un nuevo examinador de archivos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Dossier";
	menu_name = "Nouveau navigateur de Fichier";
	tooltip = "Crer un nouveau navigateur de fichier";
#endif
	accel_key = GDK_1;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_NEW_IMBR;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)image_browser_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "IBrowser";
	menu_name = "New Image Browser";
	tooltip = "Create a new image browser";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "IBrowser";
	menu_name = "Nuevo Examinador De Imagenes";
	tooltip = "Muestra un nuevo examinador de imagenes";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Galerie";
	menu_name = "Nouveau Navigateur d'Image";
	tooltip = "Crer un nouveau navigateur d'image";
#endif
	accel_key = GDK_2;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_NEW_ARCHIVER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)archiver_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Archiver";
	menu_name = "New Archiver";
	tooltip = "Create a new archiver";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Archiver";
	menu_name = "Nuevo Compresor De Archivos";
	tooltip = "Muestra un archivo comprimido nuevo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Archive";
	menu_name = "Nouvelle Archive";
	tooltip = "Crer un nouvelle archive";
#endif
	accel_key = GDK_3;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_OPTIONS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_options2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Options";
	menu_name = "Options...";
	tooltip = "Modify this application's options";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Las Opciones";
	menu_name = "Las Opciones...";
	tooltip = "Modifican estas opciones de la aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Options";
	menu_name = "Options";
	tooltip = "Modifier les options de l'application";
#endif
	accel_key = GDK_o;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_CUSTOMIZE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_customize_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Custom";
	menu_name = "Customize...";
	tooltip = "Customize the look and feel of this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Personal";
	menu_name = "Personaliza...";
	tooltip = "Personaliza la mirada y se siente de esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Prfrences";
	menu_name = "Prfrences...";
	tooltip = "Rgle les prfrences pour cette application";
#endif
	accel_key = GDK_t;
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_HELP_CONTENTS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Help";
	menu_name = "Contents";
	tooltip = "Index of all help pages";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Ayuda";
	menu_name = "El Contenido";
	tooltip = "El Indice de toda ayuda pagina";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Aide";
	menu_name = "Contenu d'aide";
	tooltip = "Index de toutes les pages d'aide";
#endif
	accel_key = GDK_F1;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_FILE_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "File Browser";
	tooltip = "Help on using the file browser";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_IMAGE_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Image Browser";
	tooltip = "Help on using the image browser";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_ARCHIVER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Archiver";
	tooltip = "Help on using the archiver";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_RECYCLE_BIN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Aide";
	menu_name = "Corbeille";
	tooltip = "aide sur l'utilisation de la Corbeille";
#else
	button_name = "Help";
	menu_name = "Recycle Bin";
	tooltip = "Help on using the recycle bin";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_KEYS_LIST;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpKeys";
	menu_name = "Keys List";
	tooltip = "List of all keyboard key operations";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpKeys";
	menu_name = "La Lista De Llaves";
	tooltip = "La Lista de todo teclado las operaciones claves";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Raccourcis";
	menu_name = "Raccourcis clavier";
	tooltip = "Liste des raccourcis clavier pour les oprations principales";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_COMMON_OPERATIONS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpOp";
	menu_name = "Common Operations";
	tooltip = "Help on the most common operations";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpOp";
	menu_name = "Las Operaciones Comunes";
	tooltip = "La Ayuda en las operaciones ms comunes";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Oprations";
	menu_name = "Les Oprations Communes";
	tooltip = "Aide sur montage des composants";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_ABOUT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	flags = 0;
	button_icon_data = (guint8 **)icon_about_20x20_xpm;
	menu_icon_data = (guint8 **)icon_about_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "About";
	menu_name = "About";
	tooltip = "About this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Acerca";
	menu_name = "Acerca De";
	tooltip = "Acerca de esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "A propos";
	menu_name = "A propos";
	tooltip = "A propos de cette application";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	return(opid_list);
#undef DO_APPEND_OPID
}

/*
 *	Deletes the Recycle Bin Operation IDs list.
 */
void EDVRecBinOPIDListDelete(GList *glist)
{
	GList *opid_list = glist;
	edv_recbin_opid_struct *opid;

	for(; glist != NULL; glist = g_list_next(glist))
	{
	    opid = EDV_RECBIN_OPID(glist->data);
	    if(opid == NULL)
		continue;

	    g_free(opid->button_name);
	    g_free(opid->menu_name);
	    g_free(opid->tooltip);

	    g_free(opid);
	}
	g_list_free(opid_list);
}


/*
 *	Creates a new Accel Key List with default values.
 */
cfg_accelkey_list_struct *EDVRecBinAccelkeysListNewDefault(void)
{
	GList *glist, *opid_list, *ak_glist = NULL;
	cfg_accelkey_list_struct *ak_list;
	edv_recbin_opid_struct *opid;

	opid_list = EDVRecBinOPIDListNew(NULL);
	for(glist = opid_list; glist != NULL; glist = g_list_next(glist))
	{
	    opid = EDV_RECBIN_OPID(glist->data);
	    if(opid == NULL)
		continue;

	    if(opid->flags & EDV_OPID_NO_OP)
		continue;

	    ak_glist = g_list_append(
		ak_glist,
		CFGAccelkeyNew(
		    (gint)opid->op,
		    opid->accel_key,
		    opid->accel_mods
		)
	    );
	}
	EDVRecBinOPIDListDelete(opid_list);

	ak_list = CFGAccelkeyListNew(ak_glist);

	g_list_foreach(ak_glist, (GFunc)CFGAccelkeyDelete, NULL);
	g_list_free(ak_glist);

	return(ak_list);
}


/*
 *	Creates the Recycle Bin Menu Bar.
 *
 *	This function should be called by EDVRecBinNew().
 */
static void EDVRecBinCreateMenuBar(
	edv_recbin_struct *recbin, GtkWidget *parent
)
{
	guint8 **icon_data = NULL;
	edv_recbin_op op;
	GtkAccelGroup *accelgrp = NULL;
	GtkWidget *w, *menu, *menu_bar;

	/* Create Menu Bar */
	recbin->menu_bar = menu_bar = GUIMenuBarCreate(NULL);
	gtk_container_add(GTK_CONTAINER(parent), menu_bar);
	gtk_widget_show(menu_bar);

#define DO_ADD_MENU_ITEM_LABEL		{	\
 edv_recbin_opid_struct *opid =			\
  EDVRecBinMatchOPID(recbin, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (icon_data != NULL) ?			\
    icon_data : opid->menu_icon_data,		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods, NULL,	\
   opid, EDVRecBinMenuItemCB			\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVRecBinMenuItemEnterCB, opid,	\
   (gpointer)EDVRecBinMenuItemLeaveCB, opid	\
  );						\
 } else {					\
  w = NULL;					\
 }						\
}

#define DO_ADD_MENU_ITEM_CHECK	{		\
 edv_recbin_opid_struct *opid =			\
  EDVRecBinMatchOPID(recbin, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_CHECK, accelgrp,	\
   (icon_data != NULL) ?			\
    icon_data : opid->menu_icon_data,		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods, NULL,	\
   opid, EDVRecBinMenuItemCB			\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVRecBinMenuItemEnterCB, opid,	\
   (gpointer)EDVRecBinMenuItemLeaveCB, opid	\
  );						\
 } else {					\
  w = NULL;					\
 }						\
}

#define DO_ADD_MENU_SEP	{			\
 w = GUIMenuItemCreate(				\
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,	\
  NULL, NULL, 0, 0, NULL,			\
  NULL, NULL					\
 );						\
}

	/* Create Menus */
	/* File */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_RECOVER;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->recover_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_PURGE;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->purge_mi = w;

	    op = EDV_RECBIN_OP_PURGE_ALL;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->purge_all_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_SYNC_RECYCLE_BIN;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->sync_recycle_bin_mi = w;

	    op = EDV_RECBIN_OP_SYNC_DISKS;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->sync_disks_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_HISTORY;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->history_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_RUN;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->run_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_CLOSE;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->close_mi = w;
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Fichier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Akte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"File"
#elif defined(PROG_LANGUAGE_DUTCH)
"Dossier"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv"
#else
"File"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);

	/* Edit */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_RECOVER;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->edit_recover_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_PURGE;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->edit_purge_mi = w;

	    op = EDV_RECBIN_OP_PURGE_ALL;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->edit_purge_all_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_SELECT_ALL;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->select_all_mi = w;

	    op = EDV_RECBIN_OP_UNSELECT_ALL;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->unselect_all_mi = w;

	    op = EDV_RECBIN_OP_INVERT_SELECTION;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->invert_selection_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_FIND;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->find_mi = w;
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Editar"
#elif defined(PROG_LANGUAGE_FRENCH)
"Editer"
#elif defined(PROG_LANGUAGE_GERMAN)
"Redigieren"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Redigere"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewerking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Edite"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rediger"
#else
"Edit"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* View Menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_REFRESH;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->refresh_mi = w;

	    op = EDV_RECBIN_OP_REFRESH_ALL;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->refresh_all_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_SHOW_TOOL_BAR;
	    DO_ADD_MENU_ITEM_CHECK
	    recbin->show_tool_bar_micheck = w;

	    op = EDV_RECBIN_OP_SHOW_FIND_BAR;
	    DO_ADD_MENU_ITEM_CHECK
	    recbin->show_find_bar_micheck = w;

	    op = EDV_RECBIN_OP_SHOW_STATUS_BAR;
	    DO_ADD_MENU_ITEM_CHECK
	    recbin->show_status_bar_micheck = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_CONTENTS_LIST_FILTER;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->contents_list_filter_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_MIME_TYPES;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->mime_types_mi = w;
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Vista"
#elif defined(PROG_LANGUAGE_FRENCH)
"Voir"
#elif defined(PROG_LANGUAGE_GERMAN)
"Blick"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Veduta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Overzicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Vista"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sikt"
#else
"View"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Settings Menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_WRITE_PROTECT;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->write_protect_mi = w;

	    op = EDV_RECBIN_OP_DELETE_METHOD_RECYCLE;
	    DO_ADD_MENU_ITEM_CHECK
	    recbin->delete_method_recycle_micheck = w;

	    op = EDV_RECBIN_OP_DELETE_METHOD_PURGE;
	    DO_ADD_MENU_ITEM_CHECK
	    recbin->delete_method_purge_micheck = w;


	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_OPTIONS;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->options_mi = w;

	    op = EDV_RECBIN_OP_CUSTOMIZE;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->customize_mi = w;
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Configuracion"
#elif defined(PROG_LANGUAGE_FRENCH)
"Rglages"
#elif defined(PROG_LANGUAGE_GERMAN)
"Setzen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Zetten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Por"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innstillinger"
#else
"Settings"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);

	/* Windows */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_NEW_BROWSER;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->window_new_browser_mi = w;

	    op = EDV_RECBIN_OP_NEW_IMBR;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->window_new_imbr_mi = w;

	    op = EDV_RECBIN_OP_NEW_ARCHIVER;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->window_new_archiver_mi = w;
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Ventanas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Fentres"
#elif defined(PROG_LANGUAGE_GERMAN)
"Fenster"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Finestre"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ramen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Janelas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vinduer"
#else
"Windows"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);

	/* Help */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_HELP_CONTENTS;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->help_contents_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_HELP_RECYCLE_BIN;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->help_recycle_bin_mi = w;

	    op = EDV_RECBIN_OP_HELP_KEYS_LIST;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->help_keys_list_mi = w;

	    op = EDV_RECBIN_OP_HELP_COMMON_OPERATIONS;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->help_common_operations_mi = w;

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_HELP_ABOUT;
	    DO_ADD_MENU_ITEM_LABEL
	    recbin->help_about_mi = w;
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Ayuda"
#elif defined(PROG_LANGUAGE_FRENCH)
"Aide"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hilfe"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Aiuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hulp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ajuda"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hjelp"
#else
"Help"
#endif
	    , GUI_MENU_BAR_ALIGN_RIGHT
	);

#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_ITEM_CHECK
#undef DO_ADD_MENU_SEP
}

/*
 *	Creates a new Recycle Bin.
 */
edv_recbin_struct *EDVRecBinNew(edv_core_struct *core)
{
	gint	toplevel_x, toplevel_y,
		toplevel_width, toplevel_height;
	gboolean	tool_bar_map_state,
			find_bar_map_state,
			status_bar_map_state;
	gint i;
	const gchar *wm_name, *wm_class;
	GdkWindow *window;
	GtkRcStyle *standard_rcstyle, *lists_rcstyle;
	GtkStyle *style;
	GtkWidget	*w,
			*parent, *parent2,
			*toplevel;
	GtkCList *clist;
	const GtkTargetEntry dnd_tar_types[] = {
{GUI_TARGET_NAME_TEXT_PLAIN,	0,	EDV_DND_INFO_TEXT_PLAIN},
{GUI_TARGET_NAME_TEXT_URI_LIST,	0,	EDV_DND_INFO_TEXT_URI_LIST},
{GUI_TARGET_NAME_STRING,	0,	EDV_DND_INFO_STRING}
	};
	const GtkTargetEntry dnd_src_types[] = {
{EDV_DND_TARGET_RECYCLED_OBJECT, 0,	EDV_DND_INFO_RECYCLED_OBJECT}
	};
	const cfg_item_struct *cfg_list;
	edv_status_bar_struct *status_bar;
	edv_recbin_struct *recbin;

	if(core == NULL)
	    return(NULL);

	cfg_list = core->cfg_list;
	standard_rcstyle = core->standard_rcstyle;
	lists_rcstyle = core->lists_rcstyle;
	wm_name = core->wm_name;
	wm_class = core->wm_class;
	if(core->geometry_set)
	{
	    const GdkRectangle *rect = &core->geometry;
	    toplevel_x = rect->x;
	    toplevel_y = rect->y;
	    toplevel_width = rect->width;
	    toplevel_height = rect->height;
	}
	else
	{
	    toplevel_x = EDV_GET_I(EDV_CFG_PARM_RECBIN_X);
	    toplevel_y = EDV_GET_I(EDV_CFG_PARM_RECBIN_Y);
	    toplevel_width = EDV_GET_I(EDV_CFG_PARM_RECBIN_WIDTH);
	    toplevel_height = EDV_GET_I(EDV_CFG_PARM_RECBIN_HEIGHT);
	}

	tool_bar_map_state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR);
	find_bar_map_state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR);
	status_bar_map_state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR);


	/* Create the Recycle Bin */
	recbin = EDV_RECBIN(g_malloc0(sizeof(edv_recbin_struct)));
	if(recbin == NULL)
	    return(NULL);

	recbin->toplevel = toplevel = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	recbin->processing = FALSE;
	recbin->freeze_count = 0;
	recbin->busy_count = 0;
	recbin->core = core;

	recbin->opid_list = EDVRecBinOPIDListNew(recbin);

	recbin->tool_bar_map_state = tool_bar_map_state;
	recbin->find_bar_map_state = find_bar_map_state;
	recbin->status_bar_map_state = status_bar_map_state;
	recbin->contents_list_filter = STRDUP(EDV_GET_S(
	    EDV_CFG_PARM_RECBIN_CONTENTS_LIST_FILTER
	));
	recbin->contents_clist_selected_row = -1;
	recbin->last_recbin_items = -1;
	recbin->last_write_protect_state = -1;
	recbin->find_bar = NULL;
	recbin->status_bar = NULL;

	recbin->freeze_count++;

	/* Toplevel GtkWindow */
	w = toplevel;
	gtk_widget_set_name(w, EDV_RECBIN_TOPLEVEL_WIDGET_NAME);
	gtk_window_set_policy(GTK_WINDOW(w), TRUE, TRUE, TRUE);
	gtk_widget_set_uposition(
	    w, toplevel_x, toplevel_y
	);
	gtk_widget_set_usize(
	    w, toplevel_width, toplevel_height
	);
	if(!STRISEMPTY(wm_name) && !STRISEMPTY(wm_class))
	    gtk_window_set_wmclass(GTK_WINDOW(w), wm_name, wm_class);
	else
	    gtk_window_set_wmclass(
		GTK_WINDOW(w), "recyclebin", PROG_NAME
	    );
	gtk_widget_realize(w);
	window = w->window;
	if(window != NULL)
	{
	    GdkGeometry geo;

	    geo.min_width = 100;
	    geo.min_height = 70;
	    geo.base_width = 0;
	    geo.base_height = 0;
	    geo.width_inc = 1;
	    geo.height_inc = 1;
	    gdk_window_set_geometry_hints(
		window, &geo,
		GDK_HINT_MIN_SIZE |
		GDK_HINT_BASE_SIZE |
		GDK_HINT_RESIZE_INC
	    );
	}
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(EDVRecBinDeleteEventCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVRecBinKeyEventCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVRecBinKeyEventCB), recbin
	);
	style = gtk_widget_get_style(w);
	parent = w;


	/* Main vbox */
	recbin->main_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;


	/* Vbox for tool bars */
	recbin->bars_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Handle for menu bar */
	recbin->menu_bar_handle = w = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildAttachedCB), recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildDetachedCB), recbin
	);
	gtk_widget_show(w);
	/* Create menu bar */
	EDVRecBinCreateMenuBar(recbin, w);


	/* Handle for tool bar */
	recbin->tool_bar_handle = w = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildAttachedCB), recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildDetachedCB), recbin
	);
	if(recbin->tool_bar_map_state)
	    gtk_widget_show(w);
	/* Build tool bar later */
	recbin->tool_bar = NULL;


	/* GtkHandleBox for the Find Bar */
	recbin->find_bar_handle = w = gtk_handle_box_new();
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildAttachedCB), recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildDetachedCB), recbin
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	if(recbin->find_bar_map_state)
	    gtk_widget_show(w);
	parent2 = w;

	/* Create the Find Bar */
	recbin->find_bar = EDVFindBarNew(
	    core, parent2,
	    EDV_FINDBAR_ROLE_RECYCLED_OBJECT,
	    NULL,
	    EDVRecBinFindBarStartCB,
	    EDVRecBinFindBarEndCB,
	    EDVRecBinFindBarMatchCB,
	    EDVRecBinStatusMessageCB,
	    EDVRecBinStatusProgressCB,
	    recbin
	);
	EDVFindBarMap(recbin->find_bar);


	/* Scrolled window for contents clist */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_AUTOMATIC,
	    GTK_POLICY_AUTOMATIC
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Contents clist */
	recbin->contents_clist = w = gtk_clist_new(
	    EDV_RECBIN_CONTENTS_CLIST_COLUMNS_MAX
	);
	clist = GTK_CLIST(w);
	gtk_widget_set_name(w, EDV_RECBIN_CLIST_WIDGET_NAME);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(EDVCListMotionEventCB), core
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVRecBinKeyEventCB), recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVRecBinKeyEventCB), recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVRecBinButtonPressEventCB), recbin
	);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_widget_realize(w);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_EXTENDED);
	for(i = 0; i < clist->columns; i++)
	    gtk_clist_set_column_width(clist, i, 10);
	gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_signal_connect(
	    GTK_OBJECT(w), "resize_column",
	    GTK_SIGNAL_FUNC(EDVRecBinResizeColumnCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "click_column",
	    GTK_SIGNAL_FUNC(EDVRecBinClickColumnCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "select_row",
	    GTK_SIGNAL_FUNC(EDVRecBinSelectRowCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "unselect_row",
	    GTK_SIGNAL_FUNC(EDVRecBinUnselectRowCB), recbin
	);
	/* Set up DND for the contents list */
	GUIDNDSetSrc(
	    w,
	    dnd_src_types,
	    sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_MOVE,			/* Actions */
	    GDK_BUTTON1_MASK,			/* Buttons */
	    NULL,
	    EDVRecBinContentsDragDataGetCB,
	    EDVRecBinContentsDragDataDeleteCB,
	    NULL,
	    recbin
	);
	GUIDNDSetTar(
	    w,
	    dnd_tar_types,
	    sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_MOVE,			/* Actions */
	    GDK_ACTION_MOVE,			/* Default action if same */
	    GDK_ACTION_MOVE,			/* Default action */
	    EDVRecBinContentsDragDataReceivedCB,
	    recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "drag_motion",
	    GTK_SIGNAL_FUNC(EDVRecBinContentsDragMotionCB), recbin
	);
	gtk_widget_show(w);



	/* Create the Tool Bar */
	EDVRecBinToolBarRegenerate(recbin);

	/* Create the Contents List Menu */
	EDVRecBinContentsMenuRegenerate(recbin);


	/* Create the Status Bar */
	recbin->status_bar = status_bar = EDVStatusBarNew(
	    core, recbin->main_vbox
	);
	if(status_bar != NULL)
	{
	    if(recbin->status_bar_map_state)
		EDVStatusBarMap(status_bar);
	    else
		EDVStatusBarUnmap(status_bar);
	}


	/* Set initial RC styles */
	if(standard_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		recbin->toplevel, standard_rcstyle
	    );
	if(lists_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		recbin->contents_clist, lists_rcstyle
	    );
	if(standard_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		recbin->contents_clist_menu, standard_rcstyle
	    );

	/* Set the initial values */
	EDVRecBinSetTitle(recbin);
	EDVRecBinAccelkeysRegenerate(recbin);
	EDVRecBinUpdateMenus(recbin);

	recbin->freeze_count--;

	return(recbin);
}

/*
 *	Syncronizes all data in the recycle bin's widgets to internal data
 *	on the recycle bin.
 */
void EDVRecBinSyncData(edv_recbin_struct *recbin)
{
	if(recbin == NULL)
	    return;

/* This function may be removed in the future, since there really is
 * no floating data from widgets to be synced to disk on the recycle bin
 */
}

/*
 *	Updates all widgets on the given recycle bin to reflect the current
 *	data.
 */
void EDVRecBinUpdateMenus(edv_recbin_struct *recbin)
{
	gboolean	write_protect,
			write_protect_changed = FALSE,
			sensitive,
			state;
	edv_delete_method delete_method;
	const cfg_item_struct *cfg_list;
	guint8		**recbin_icon_data,
			**recbin_icon_large_data;
	GtkWidget *w;
	GtkCList *clist;
	gint selected_obj_row = -1;
	toolbar_struct *tb;
	edv_core_struct *core;

	if(recbin == NULL)
	    return;

	recbin->freeze_count++;

	tb = recbin->tool_bar;
	core = recbin->core;
	cfg_list = core->cfg_list;

#define DO_SHOW			\
{ if(w != NULL) gtk_widget_show(w); }
#define DO_HIDE			\
{ if(w != NULL) gtk_widget_hide(w); }
#define DO_SET_CHECK_STATE	\
{ GUIMenuItemSetCheck(w, state, FALSE); }

	/* Get global write protect state */
	write_protect = EDV_GET_B(EDV_CFG_PARM_WRITE_PROTECT);
	if(recbin->last_write_protect_state < 0)
	{
	    write_protect_changed = TRUE;
	}
	else
	{
	    if((write_protect && !recbin->last_write_protect_state) ||
	       (!write_protect && recbin->last_write_protect_state)
	    )
		write_protect_changed = TRUE;
	}
	recbin->last_write_protect_state = write_protect ? 1 : 0;

	/* Delete method */
	delete_method = (edv_delete_method)EDV_GET_I(
	    EDV_CFG_PARM_DELETE_METHOD
	);

	/* Get last selected row on the contents clist */
	clist = (GtkCList *)recbin->contents_clist;
	selected_obj_row = EDVCListGetSelectedLast(clist, NULL);

	/* Update recycle bin icon data, setting it to not NULL if it
	 * needs to be changed and update the recycle bin's
	 * last_recbin_items to match the value on the core structure
	 */
	recbin_icon_data = NULL;
	recbin_icon_large_data = NULL;
	if(recbin->last_recbin_items < 0)
	{
	    if(core->last_recbin_items > 0)
	    {
		recbin_icon_data = (guint8 **)icon_trash_20x20_xpm;
		recbin_icon_large_data = (guint8 **)icon_trash_48x48_xpm;
	    }
	    else
	    {
		recbin_icon_data = (guint8 **)icon_trash_empty_20x20_xpm;
		recbin_icon_large_data = (guint8 **)icon_trash_empty_48x48_xpm;
	    }
	}
	else
	{
	    if(!recbin->last_recbin_items &&
	       core->last_recbin_items
	    )
	    {
		recbin_icon_data = (guint8 **)icon_trash_20x20_xpm;
		recbin_icon_large_data = (guint8 **)icon_trash_48x48_xpm;
	    }
	    else if(recbin->last_recbin_items &&
		    !core->last_recbin_items
	    )
	    {
		recbin_icon_data = (guint8 **)icon_trash_empty_20x20_xpm;
		recbin_icon_large_data = (guint8 **)icon_trash_empty_48x48_xpm;
	    }
	}
	recbin->last_recbin_items = core->last_recbin_items;


        /* Update the find bar */
        EDVFindBarUpdateMenus(recbin->find_bar);


	/* Begin updating menu items and tool bar items */

	/* File */
	sensitive = (selected_obj_row > -1) ? TRUE : FALSE;
	/* Recover */
	GTK_WIDGET_SET_SENSITIVE(recbin->recover_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(recbin->edit_recover_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_RECBIN_OP_RECOVER, sensitive
	);
	/* Purge */
	GTK_WIDGET_SET_SENSITIVE(recbin->purge_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(recbin->edit_purge_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_RECBIN_OP_PURGE, sensitive
	);

	/* Sync Recycle bin */
	if(recbin_icon_data != NULL)
	{
	    GUIMenuItemSetPixmap(
		recbin->sync_recycle_bin_mi, recbin_icon_data
	    );
	    ToolBarItemUpdateByID(
		tb, EDV_RECBIN_OP_SYNC_RECYCLE_BIN,
		NULL, recbin_icon_data, NULL
	    );
	}


	/* View */
	/* Show Tool Bar */
	w = recbin->show_tool_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_RECBIN_OP_SHOW_TOOL_BAR, state
	);
	/* Show Find Bar */
	w = recbin->show_find_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_RECBIN_OP_SHOW_FIND_BAR, state
	);
	/* Show Status Bar */
	w = recbin->show_status_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_RECBIN_OP_SHOW_STATUS_BAR, state
	);


	/* Settings */
	if(write_protect_changed)
	{
	    w = recbin->write_protect_mi;
	    if(w != NULL)
		GUIMenuItemSetPixmap(
		    w,
		    (guint8 **)(write_protect ?
			icon_secure_20x20_xpm : icon_insecure_20x20_xpm)
		);
	    ToolBarItemUpdateByID(
		tb, EDV_RECBIN_OP_WRITE_PROTECT,
		NULL,
		(guint8 **)(write_protect ?
		    icon_secure_20x20_xpm : icon_insecure_20x20_xpm),
		NULL
	    );
	}

	/* Delete Method: Recycle */
	w = recbin->delete_method_recycle_micheck;
	GUIMenuItemSetPixmap(w, recbin_icon_data);
	state = (delete_method == EDV_DELETE_METHOD_RECYCLE) ?
	    TRUE : FALSE;
	DO_SET_CHECK_STATE
	ToolBarItemUpdateByID(
	    tb, EDV_RECBIN_OP_DELETE_METHOD_RECYCLE,
	    NULL, recbin_icon_data, NULL                              
	);
	ToolBarItemSetToggleID(
	    tb, EDV_RECBIN_OP_DELETE_METHOD_RECYCLE, state
	);

	/* Delete Method: Purge */
	w = recbin->delete_method_purge_micheck;
	state = (delete_method == EDV_DELETE_METHOD_PURGE) ?
	    TRUE : FALSE;
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_RECBIN_OP_DELETE_METHOD_PURGE, state
	);


	/* Windows */


	/* Update contents clist menu */
	sensitive = (selected_obj_row > -1) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(
	    recbin->contents_clist_purge_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    recbin->contents_clist_recover_mi, sensitive
	)



	/* Update status bar */
	EDVStatusBarUpdate(recbin->status_bar);



	/* Update toplevel GdkWindow's WM icon */
	w = recbin->toplevel;
	if(((w != NULL) ? (w->window != NULL) : FALSE) &&
	   (recbin_icon_large_data != NULL)
	)
	    GUISetWMIcon(w->window, (guint8 **)recbin_icon_large_data);


#undef DO_SHOW
#undef DO_HIDE
#undef DO_SET_CHECK_STATE

	recbin->freeze_count--;
}

/*
 *	Sets the Recycle Bin as busy or ready.
 */
void EDVRecBinSetBusy(edv_recbin_struct *recbin, gboolean busy)
{
	GdkCursor *cur;
	GtkWidget *w;
	edv_core_struct *core;

	if(recbin == NULL)
	    return;

	w = recbin->toplevel;
	core = recbin->core;

	if(busy)
	{
	    recbin->busy_count++;
	    if(recbin->busy_count > 1)
		return;
	    cur = EDVGetCursor(core, EDV_CURSOR_CODE_BUSY);
	}
	else
	{
	    recbin->busy_count--;
	    if(recbin->busy_count < 0)
		recbin->busy_count = 0;
	    if(recbin->busy_count > 0)
		return;
	    cur = NULL;
	}

	if(w->window != NULL)
	{
	    gdk_window_set_cursor(w->window, cur);
	    gdk_flush();
	}
}

/*
 *	Checks if the Recycle Bin is mapped.
 */
gboolean EDVRecBinIsMapped(edv_recbin_struct *recbin)
{
        if(recbin == NULL)
            return(FALSE);

	return(GTK_WIDGET_MAPPED(recbin->toplevel));
}

/*
 *	Maps the Recycle Bin.
 */
void EDVRecBinMap(edv_recbin_struct *recbin)
{
	if(recbin == NULL)
	    return;

	gtk_widget_show_raise(recbin->toplevel);
}

/*
 *	Unmaps the Recycle Bin.
 */
void EDVRecBinUnmap(edv_recbin_struct *recbin)
{
	if(recbin == NULL)
	    return;

	gtk_widget_hide(recbin->toplevel);
}

/*
 *	Deletes the Recycle Bin.
 */
void EDVRecBinDelete(edv_recbin_struct *recbin)
{
	if(recbin == NULL)
	    return;

	/* Reset the last selected item references */
	recbin->contents_clist_selected_row = -1;


	EDVRecBinUnmap(recbin);

	recbin->freeze_count++;

	GTK_WIDGET_DESTROY(recbin->contents_clist_menu);

	EDVStatusBarDelete(recbin->status_bar);
	EDVFindBarDelete(recbin->find_bar);
	ToolBarDelete(recbin->tool_bar);
	GTK_WIDGET_DESTROY(recbin->toplevel);

	/* Delete all Operation IDs */
	EDVRecBinOPIDListDelete(recbin->opid_list);

	g_free(recbin->contents_list_filter);

	recbin->freeze_count--;

	g_free(recbin);
}
