#ifndef EDV_ARCHIVE_EXTRACT_H
#define EDV_ARCHIVE_EXTRACT_H

#include <gtk/gtk.h>
#include "edv_types.h"


/* Error Message */
extern const gchar *EDVArchExtractGetError(edv_core_struct *core);
extern void EDVArchExtractCopyErrorMessage(
	edv_core_struct *core, const gchar *msg
);

/* Progress Dialog */
extern void EDVArchExtractMapProgressDialog(
	const gchar *label, const gfloat progress,
	GtkWidget *toplevel, const gboolean force_remap
);

/* Mkdir Recursive */
extern gint EDVArchExtractRMkDir(const gchar *path, GList **new_paths_list_rtn);

/* Remove Recursive */
extern gint EDVArchExtractRemove(const gchar *path);

/* Extract From Archive */
extern gint EDVArchExtract(
	edv_core_struct *core,
	const gchar *arch_path,
	GList *obj_list,			/* List of edv_archive_object_struct * objects */
	const gboolean extract_all,
	const gchar *dest_path,
	GList **new_paths_list_rtn,		/* Return list of gchar * paths */
	const gchar *password,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all,
	const gboolean preserve_directories,
	const gboolean preserve_timestamps
);


#endif	/* EDV_ARCHIVE_EXTRACT_H */
