/*
			       Endeavour Archiver
 */

#ifndef ARCHIVER_H
#define ARCHIVER_H

#include <gtk/gtk.h>
#include "cfg.h"
#include "toolbar.h"
#include "edv_types.h"
#include "edv_find_bar.h"
#include "edv_status_bar.h"
#include "archive_info_dlg.h"


typedef struct _edv_archiver_struct	edv_archiver_struct;
#define EDV_ARCHIVER(p)			((edv_archiver_struct *)(p))
typedef struct _edv_archiver_opid_struct	edv_archiver_opid_struct;
#define EDV_ARCHIVER_OPID(p)		((edv_archiver_opid_struct *)(p))


/*
 *	Archiver Contents List Column Types:
 */
typedef enum {

	EDV_ARCHIVER_COLUMN_TYPE_NAME			= 0,
	EDV_ARCHIVER_COLUMN_TYPE_SIZE			= 1,
	EDV_ARCHIVER_COLUMN_TYPE_COMPRESSED_SIZE	= 2,
	EDV_ARCHIVER_COLUMN_TYPE_TYPE			= 3,
	EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS		= 4,
	EDV_ARCHIVER_COLUMN_TYPE_OWNER			= 5,
	EDV_ARCHIVER_COLUMN_TYPE_GROUP			= 6,
	EDV_ARCHIVER_COLUMN_TYPE_DATE_ACCESS		= 7,
	EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED		= 8,
	EDV_ARCHIVER_COLUMN_TYPE_DATE_CHANGED		= 9,
	EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO		= 10,
	EDV_ARCHIVER_COLUMN_TYPE_LOCATION		= 11,
	EDV_ARCHIVER_COLUMN_TYPE_DEVICE_TYPE		= 12,
	EDV_ARCHIVER_COLUMN_TYPE_COMPRESSION		= 13,
	EDV_ARCHIVER_COLUMN_TYPE_METHOD			= 14,
	EDV_ARCHIVER_COLUMN_TYPE_CRC			= 15

} edv_archiver_column_type;
/* Total number of column types */
#define EDV_ARCHIVER_CONTENTS_CLIST_COLUMNS_MAX		16


/*
 *	Archiver Operations:
 */
typedef enum {

	EDV_ARCHIVER_OP_NONE			= 0,
	EDV_ARCHIVER_OP_SEPARATOR		= 10,

	EDV_ARCHIVER_OP_CLOSE			= 20,
	EDV_ARCHIVER_OP_EXIT			= 21,

	EDV_ARCHIVER_OP_SYNC_DISKS		= 30,
	EDV_ARCHIVER_OP_RUN			= 31,
	EDV_ARCHIVER_OP_RUN_TERMINAL		= 32,
	EDV_ARCHIVER_OP_WRITE_PROTECT		= 35,
	EDV_ARCHIVER_OP_DELETE_METHOD_RECYCLE	= 38,
	EDV_ARCHIVER_OP_DELETE_METHOD_PURGE	= 39,

	EDV_ARCHIVER_OP_NEW			= 60,
	EDV_ARCHIVER_OP_OPEN			= 61,
	EDV_ARCHIVER_OP_ADD			= 62,
	EDV_ARCHIVER_OP_EXTRACT			= 63,
	EDV_ARCHIVER_OP_EXTRACT_ALL		= 64,
	EDV_ARCHIVER_OP_DELETE			= 65,
	EDV_ARCHIVER_OP_CHECK			= 67,
	EDV_ARCHIVER_OP_FIX			= 68,
	EDV_ARCHIVER_OP_SELECT_ALL		= 70,
	EDV_ARCHIVER_OP_UNSELECT_ALL		= 71,
	EDV_ARCHIVER_OP_INVERT_SELECTION	= 72,
	EDV_ARCHIVER_OP_FIND			= 73,
	EDV_ARCHIVER_OP_PROPERTIES		= 74,

	EDV_ARCHIVER_OP_HISTORY			= 77,

	EDV_ARCHIVER_OP_REFRESH			= 80,
	EDV_ARCHIVER_OP_REFRESH_ALL		= 81,
	EDV_ARCHIVER_OP_COMMENT_AND_STATISTICS	= 82,
	EDV_ARCHIVER_OP_SHOW_TOOL_BAR		= 90,
	EDV_ARCHIVER_OP_SHOW_LOCATION_BAR	= 91,
	EDV_ARCHIVER_OP_SHOW_FIND_BAR		= 92,
	EDV_ARCHIVER_OP_SHOW_STATUS_BAR		= 93,

	EDV_ARCHIVER_OP_CONTENTS_LIST_FILTER	= 97,

	EDV_ARCHIVER_OP_MIME_TYPES		= 100,

	EDV_ARCHIVER_OP_NEW_BROWSER		= 110,
	EDV_ARCHIVER_OP_NEW_IMBR		= 111,
	EDV_ARCHIVER_OP_NEW_ARCHIVER		= 112,
	EDV_ARCHIVER_OP_RECYCLE_BIN		= 113,

	EDV_ARCHIVER_OP_OPTIONS			= 150,
	EDV_ARCHIVER_OP_CUSTOMIZE		= 151,

	EDV_ARCHIVER_OP_HELP_ABOUT		= 1000,
	EDV_ARCHIVER_OP_HELP_CONTENTS		= 1001,
	EDV_ARCHIVER_OP_HELP_FILE_BROWSER	= 1002,
	EDV_ARCHIVER_OP_HELP_IMAGE_BROWSER	= 1003,
	EDV_ARCHIVER_OP_HELP_ARCHIVER		= 1004,
	EDV_ARCHIVER_OP_HELP_RECYCLE_BIN	= 1005,
	EDV_ARCHIVER_OP_HELP_KEYS_LIST		= 1006,
	EDV_ARCHIVER_OP_HELP_COMMON_OPERATIONS	= 1007

} edv_archiver_op;


/*
 *	Archiver Operation ID:
 */
struct _edv_archiver_opid_struct {

	edv_archiver_op	op;
	edv_opid_flags	flags;
	toolbar_item_type	tb_item_type;
	edv_archiver_struct	*archiver;

	/* Operation callback */
	void	(*func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	/* Enter and leave notify callbacks */
	void	(*enter_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);
	void	(*leave_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	gchar	*button_name,	/* Name as it would appear on a button */
		*menu_name,	/* Name as it would appear on a menu item */
		*tooltip;	/* Tool tip or description (one line) */

	guint	accel_key,	/* Accelerator key */
		accel_mods;	/* Accelerator key modifiers */

	guint8	**button_icon_data,	/* Shared */
		**menu_icon_data;	/* Shared */

};


/*
 *	Archiver:
 */
struct _edv_archiver_struct {

	GtkWidget	*toplevel;
	gboolean	processing;
	gint		freeze_count,
			busy_count;
	edv_core_struct	*core;

	GList		*opid_list;

	gboolean	tool_bar_map_state,
			location_bar_map_state,
			find_bar_map_state,
			status_bar_map_state;

	GtkWidget	*main_vbox,
			*menu_bar,
			*bars_vbox,		/* For the tool bars */

			*menu_bar_handle,
			*tool_bar_handle,
			*location_bar_handle,
			*find_bar_handle,

			*location_bar_hbox,     /* GtkHBox parent for location */
			*location_icon_fixed,
			*location_icon_pm,
			*location_combo,
			*location_password_entry,

			*contents_clist;	/* Contents GtkCList */

	/* Tool Bar */
	toolbar_struct		*tool_bar;

	/* Find Bar */
	edv_findbar_struct	*find_bar;

	/* Menus and Menu Items */
	GtkWidget	*new_mi,
			*open_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*edit_add_mi,
			*edit_extract_mi,
			*edit_extract_all_mi,
			*edit_delete_mi,
			*check_mi,
			*fix_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,
			*properties_mi,

			*refresh_mi,
			*refresh_all_mi,
			*comment_and_statistics_mi,
			*show_tool_bar_micheck,
			*show_location_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*contents_list_filter_mi,
			*mime_types_mi,

			*write_protect_mi,
			*delete_method_recycle_micheck,
			*delete_method_purge_micheck,
			*options_mi,
			*customize_mi,

			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,
			*window_recycle_bin_mi,

			*help_contents_mi,
			*help_archiver_mi,
			*help_keys_list_mi,
			*help_common_operations_mi,
			*help_about_mi;

	/* Contents clist right-click menu */
	GtkWidget       *contents_clist_menu,
			*contents_clist_add_mi,
			*contents_clist_extract_mi,
			*contents_clist_extract_all_mi,
			*contents_clist_delete_mi,
			*contents_clist_comment_and_statistics_mi,
			*contents_clist_check_mi,
			*contents_clist_fix_mi,
			*contents_clist_properties_mi;

	gchar		*contents_list_filter;

	/* Last selected row on the clist, can be -1. Note that
	 * this does not reflect other selected rows since multiple
	 * selections are allowed
	 */
	gint		contents_clist_selected_row;


	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not. Can be
	 * -1 to indicate undefined
	 */
	gint		last_recbin_items;

	/* Last known write protect state, can be -1 to indicate
	 * undefined
	 */
	gint		last_write_protect_state;


	/* Status Bar */
	edv_status_bar_struct	*status_bar;

	/* Archive Info Dialog */
	edv_archive_info_dlg_struct	*arch_info_dlg;

};


/* Utilities */
extern edv_archiver_opid_struct *EDVArchiverMatchOPID(
	edv_archiver_struct *archiver, edv_archiver_op op
);

/* Title */
extern void EDVArchiverSetTitle(
	edv_archiver_struct *archiver, const gchar *path
);

/* Location */
extern gchar *EDVArchiverCurrentLocation(edv_archiver_struct *archiver);
extern void EDVArchiverSetLocation(
	edv_archiver_struct *archiver,
	const gchar *path, const gboolean record_history
);
extern void EDVArchiverUpdateLocationIcon(
	edv_archiver_struct *archiver, const gchar *path
);

/* Password */
extern gchar *EDVArchiverCurrentPassword(edv_archiver_struct *archiver);
extern void EDVArchiverSetPassword(
	edv_archiver_struct *archiver, const gchar *password
);

/* Regenerate Style, Menus, and Tool Bar */
extern void EDVArchiverAccelkeysRegenerate(edv_archiver_struct *archiver);
extern void EDVArchiverToolBarRegenerate(edv_archiver_struct *archiver);
extern void EDVArchiverContentsMenuRegenerate(edv_archiver_struct *archiver);

/* Sync Configuration */
extern void EDVArchiverSyncConfiguration(edv_archiver_struct *archiver);

/* Select Archive */
extern void EDVArchiverOpenArchive(
	edv_archiver_struct *archiver, const gchar *arch_obj,
	const gchar *password
);

/* Operation IDs */
extern GList *EDVArchiverOPIDListNew(
	edv_archiver_struct *archiver		/* Can be NULL */
);
extern void EDVArchiverOPIDListDelete(GList *glist);

/* Accel Keys */
extern cfg_accelkey_list_struct *EDVArchiverAccelkeysListNewDefault(void);

/* Archiver */
extern edv_archiver_struct *EDVArchiverNew(edv_core_struct *core);
extern void EDVArchiverSyncData(edv_archiver_struct *archiver);
extern void EDVArchiverUpdateMenus(edv_archiver_struct *archiver);
extern void EDVArchiverUpdateContentsHeadings(
	edv_archiver_struct *archiver,
	const gint *contents_heading, gint total_contents_headings
);
extern void EDVArchiverSetBusy(edv_archiver_struct *archiver, gboolean busy);
extern gboolean EDVArchiverIsMapped(edv_archiver_struct *archiver);
extern void EDVArchiverMap(edv_archiver_struct *archiver);
extern void EDVArchiverUnmap(edv_archiver_struct *archiver);
extern void EDVArchiverDelete(edv_archiver_struct *archiver);


#endif	/* ARCHIVER_H */
