/*
	         Endeavour MIME Types List & Edit Window
 */

#ifndef MIME_TYPES_LIST_WIN_H
#define MIME_TYPES_LIST_WIN_H

#include <gtk/gtk.h>

#include "pulist.h"
#include "editclist.h"
#include "edv_types.h"
#include "edv_mime_type.h"


typedef struct _edv_mime_type_icon_picker_struct	edv_mime_type_icon_picker_struct;
#define EDV_MIME_TYPE_ICON_PICKER(p)	((edv_mime_type_icon_picker_struct *)(p))
typedef struct _edv_mime_type_edit_dlg_struct	edv_mime_type_edit_dlg_struct;
#define EDV_MIME_TYPE_EDIT_DLG(p)	((edv_mime_type_edit_dlg_struct *)(p))
typedef struct _edv_mime_types_list_win_struct	edv_mime_types_list_win_struct;
#define EDV_MIME_TYPES_LIST_WIN(p)	((edv_mime_types_list_win_struct *)(p))


/*
 *	MIME Type Edit Window Icon Picker:
 */
struct _edv_mime_type_icon_picker_struct {

	GtkWidget	*toplevel,	/* GtkBox */
			*button,	/* Icon GtkButton */
			*gtk_pixmap,
			*left_btn, *right_btn, *state_label;

	edv_mime_type_edit_dlg_struct	*d;

	GtkAdjustment	*adj;		/* Icon state GtkAdjustment */

	gint		icon_width,	/* Requested icon size */
			icon_height;

	GdkPixmap	*pixmap[EDV_MIME_TYPE_TOTAL_ICON_STATES];
	GdkBitmap	*mask[EDV_MIME_TYPE_TOTAL_ICON_STATES];

	gchar		*path[EDV_MIME_TYPE_TOTAL_ICON_STATES];

};

/*
 *      MIME Type Edit Window:
 */
struct _edv_mime_type_edit_dlg_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	edv_core_struct	*core;

	edv_mime_types_list_win_struct	*list_win;

	gboolean	has_changes;
	gchar		*title;

	GtkWidget       *main_vbox,
			*type_entry,
			*value_label,
			*value_entry,
			*description_entry,
			*ok_btn,
			*apply_btn,
			*cancel_btn,
			*close_btn;

	pulistbox_struct	*class_pulistbox,
				*handler_pulistbox;

	editclist_struct	*editclist;

	/* Icon Pickers */
	edv_mime_type_icon_picker_struct	*icon_small,
					*icon_medium,
					*icon_large;

	/* Reference to the MIME Type being edited */
	gint		mt_num;
};

/*
 *	MIME Type List Window:
 */
struct _edv_mime_types_list_win_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	edv_core_struct	*core;

	GtkWidget	*main_vbox,
			*find_entry,
			*mimetypes_clist,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*up_btn,
			*down_btn,
			*save_btn,
			*import_btn,
			*export_btn,
			*display_parent,	/* GtkVBox */
			*display_client,
			*display_icon,
			*display_edit_btn,
			*close_btn;

	/* Right click menu */
	GtkWidget	*menu,
			*add_mi,
			*edit_mi,
			*remove_mi,
			*up_mi,
			*down_mi,
			*save_mi,
			*import_mi,
			*export_mi;

	edv_mime_type_edit_dlg_struct	*edit_dlg;

	/* Pixmap and mask pairs for the class icons */
	GdkPixmap	*system_object_pixmap;
	GdkBitmap	*system_object_mask;
	GdkPixmap	*file_format_pixmap;
	GdkBitmap	*file_format_mask;
	GdkPixmap	*program_pixmap;
	GdkBitmap	*program_mask;
	GdkPixmap	*unique_object_pixmap;
	GdkBitmap	*unique_object_mask;

};


/* In mime_type_edit_dlg.c */
extern void EDVMimeTypeEditDlgGetValues(
	edv_mime_type_edit_dlg_struct *d, const gint mt_num
);
extern void EDVMimeTypeEditDlgMimeTypeRemovedCB(
	edv_mime_type_edit_dlg_struct *d, gint mt_num
);

extern edv_mime_type_edit_dlg_struct *EDVMimeTypeEditDlgNew(
	edv_core_struct *core, edv_mime_types_list_win_struct *lw
);
extern void EDVMimeTypeEditDlgResetHasChanges(
	edv_mime_type_edit_dlg_struct *d, gboolean has_changes
);
extern void EDVMimeTypeEditDlgUpdateMenus(edv_mime_type_edit_dlg_struct *d);
extern gboolean EDVMimeTypeEditDlgIsMapped(edv_mime_type_edit_dlg_struct *d);
extern void EDVMimeTypeEditDlgMap(edv_mime_type_edit_dlg_struct *d);
extern void EDVMimeTypeEditDlgUnmap(edv_mime_type_edit_dlg_struct *d);
extern void EDVMimeTypeEditDlgDelete(edv_mime_type_edit_dlg_struct *d);


/* In mime_types_list_win.c */
extern void EDVMimeTypesListWinSelect(
	edv_mime_types_list_win_struct *lw, const gint i
);
extern gint EDVMimeTypesListWinSelectByType(
	edv_mime_types_list_win_struct *lw, const gchar *type
);

extern void EDVMimeTypesListWinSetRow(
	edv_mime_types_list_win_struct *lw,
	const gint row,
	edv_mime_type_struct *m
);
extern void EDVMimeTypesListWinFetchValues(
	edv_mime_types_list_win_struct *lw,
	const gboolean verbose
);

extern void EDVMimeTypesListWinEdit(
	edv_mime_types_list_win_struct *lw, const gint mt_num
);

extern void EDVMimeTypesListWinReconfiguredNotifyCB(
	edv_mime_types_list_win_struct *lw
);

extern void EDVMimeTypesListWinMimeTypeAddedCB(
	edv_mime_types_list_win_struct *lw,
	gint mt_num, edv_mime_type_struct *mt_ptr
);
extern void EDVMimeTypesListWinMimeTypeModifiedCB(
	edv_mime_types_list_win_struct *lw,
	gint mt_num, edv_mime_type_struct *mt_ptr
);
extern void EDVMimeTypesListWinMimeTypeRemovedCB(
	edv_mime_types_list_win_struct *lw,
	gint mt_num
);

extern edv_mime_types_list_win_struct *EDVMimeTypesListWinNew(
	edv_core_struct *core
);
extern void EDVMimeTypesListWinUpdateMenus(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinSetBusy(
	edv_mime_types_list_win_struct *lw, const gboolean busy
);
extern gboolean EDVMimeTypesListWinIsMapped(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinMap(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinUnmap(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinDelete(edv_mime_types_list_win_struct *lw);


#endif	/* MIME_TYPES_LIST_WIN_H */
