/*
			Endeavour Procedures
 */

#ifndef EDVOP_H
#define EDVOP_H

#include <gtk/gtk.h>

#include "url.h"
#include "browser.h"
#include "imbr.h"
#include "archiver.h"
#include "propdlg.h"
#include "endeavour.h"


/* New/Map Window Nexus */
extern gint EDVNewWindowNexus(
	edv_core_struct *core_ptr,
	const gchar *name,		/* Name of window */
	const gchar *path,		/* Initial object path */
	const gchar *extra,
	GtkWidget *toplevel
);


/* New Windows */
extern gint EDVNewBrowser(edv_core_struct *core_ptr);
extern gint EDVNewImbr(edv_core_struct *core_ptr);
extern gint EDVNewArchiverOpen(
	edv_core_struct *core_ptr, const gchar *path
);
extern gint EDVNewArchiver(edv_core_struct *core_ptr);

extern gint EDVNewPropertiesDialogPage(
	edv_core_struct *core_ptr, edv_object_struct *obj,
	const gchar *page_name,
	GtkWidget *toplevel
);
extern gint EDVNewPropertiesDialog(
	edv_core_struct *core_ptr, edv_object_struct *obj,
	GtkWidget *toplevel
);


/* Running */
extern void EDVRunDeviceCheck(
	edv_core_struct *core_ptr, edv_device_struct *dev,
	GtkWidget *toplevel
);
extern void EDVRunDeviceTools(
	edv_core_struct *core_ptr, edv_device_struct *dev,
	GtkWidget *toplevel
);
extern void EDVRunDeviceFormat(
	edv_core_struct *core_ptr, edv_device_struct *dev,
	GtkWidget *toplevel
);

extern void EDVRunTerminal(
	edv_core_struct *core_ptr,
	const gchar *cmd,
	const gchar *wd,
	GtkWidget *toplevel
);


/* Window Mapping */
extern void EDVMapRecBinDeskIcon(edv_core_struct *core_ptr);
extern void EDVMapRecBin(edv_core_struct *core_ptr);

extern void EDVMapHistoryListWin(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVMapOptionsWinPage(
	edv_core_struct *core_ptr,
	const gchar *page_name,
	GtkWidget *toplevel
);
extern void EDVMapOptionsWin(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVMapCustomizeWin(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVMapDevicesListWin(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVMapMIMETypesListWin(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVMapRunDialogCommand(
	edv_core_struct *core_ptr,
	const gchar *command,
	const gchar *working_dir,
	GtkWidget *toplevel
);
extern void EDVMapRunDialog(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);

extern void EDVMapBrowserFindWin(
	edv_core_struct *core_ptr, edv_browser_struct *browser
);
extern void EDVMapImbrFindWin(
	edv_core_struct *core_ptr, edv_imbr_struct *imbr
);
extern void EDVMapArchiverFindWin(
	edv_core_struct *core_ptr, edv_archiver_struct *archiver
);
extern void EDVMapRecBinFindWin(
	edv_core_struct *core_ptr, edv_recbin_struct *recbin
);


/* About */
extern void EDVAboutPage(
	edv_core_struct *core_ptr,
	const gchar *page_name,
	GtkWidget *toplevel
);
extern void EDVAbout(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);


/* Update Resources & Widgets */
extern void EDVUpdateRCStyles(edv_core_struct *core_ptr);
extern void EDVUpdateIDPULists(edv_core_struct *core_ptr);
extern void EDVUpdateDevicesPUList(edv_core_struct *core_ptr);
extern void EDVUpdateMIMETypeHintIndices(edv_core_struct *core_ptr);
extern void EDVUpdateOpenWithPUList(edv_core_struct *core_ptr);


/* Refresh & Reset */
extern void EDVRefresh(edv_core_struct *core_ptr);
extern void EDVReset(edv_core_struct *core_ptr);


/* Sync */
extern void EDVSyncDisks(edv_core_struct *core_ptr);


/* Clearing */
extern void EDVClearHistoryEvents(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);
extern void EDVClearLocationsHistory(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);
extern void EDVClearRunHistory(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);


/* Network */
extern void EDVInternetDownloadObject(
	edv_core_struct *core_ptr,
	const url_struct *url,			/* Source */
	const gchar *target_path,		/* Target */
	GtkWidget *toplevel
);


/* Recycle Bin Size Check */
extern void EDVRecycleBinSizeCheck(
	edv_core_struct *core_ptr, GtkWidget *toplevel
);


#endif	/* EDVOP_H */
