#include <gtk/gtk.h>
#include "guiutils.h"
#include "edvcursor.h"
#include "config.h"


edv_cursor_struct *EDVCursorNew(
	edv_cursor_code code, GdkCursor *gdk_cursor
);
edv_cursor_struct *EDVCursorNewGDKPreset(
	edv_cursor_code code, GdkCursorType gdk_cursor_type
);
void EDVCursorDelete(edv_cursor_struct *cursor);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates a new Cursor.
 */
edv_cursor_struct *EDVCursorNew(
	edv_cursor_code code, GdkCursor *gdk_cursor
)
{
	edv_cursor_struct *cursor = EDV_CURSOR(
	    g_malloc0(sizeof(edv_cursor_struct))
	);
	if(cursor == NULL)
	{
	    GDK_CURSOR_DESTROY(gdk_cursor);
	    return(NULL);
	}

	cursor->code = code;
	cursor->cursor = gdk_cursor;

	return(cursor);
}

/*
 *	Creates a new cursor based on the given GDK cursor type code.
 */
edv_cursor_struct *EDVCursorNewGDKPreset(
	edv_cursor_code code, GdkCursorType gdk_cursor_type
)
{
	return(EDVCursorNew(
	    code,
	    gdk_cursor_new(gdk_cursor_type)
	));
}

/*
 *	Deletes the Cursor and it's GdkCursor.
 */
void EDVCursorDelete(edv_cursor_struct *cursor)
{
	if(cursor == NULL)
	    return;

	GDK_CURSOR_DESTROY(cursor->cursor);
	g_free(cursor);
}
