/*
		     Endeavour General Options Window
 */

#ifndef OPTWIN_H
#define OPTWIN_H

#include <gtk/gtk.h>
#include "styleedit.h"
#include "stacklist.h"
#include "edvtypes.h"


/*
 *	Widget Reference structure:
 *
 *	References a widget on the Options Window to a configuration
 *	parameter cfg_parm.
 */
typedef struct {

	GtkWidget	*w;		/* Widget that holds the value */
	GtkWidget	*browse;	/* Browse button */
	gchar		*cfg_parm;	/* Cfg parameter name */

	gpointer	optwin;
	gboolean	has_changes,
			ignore_changes;

	/* Following are members use in special or extended cases */
	gint		radio_value;	/* This value is used if w is a
					 * GtkRadioButton and is active
					 */

	/* Color Button, used instead of w if not NULL */
	GtkWidget	*color_btn;

	/* Style Edit, used instead of w if not NULL */
	style_edit_struct	*style_edit;

	/* Stack List, used instead of w if not NULL */
	stack_list_struct	*slist;

} optwin_wref_struct;
#define OPTWIN_WREF(p)	((optwin_wref_struct *)(p))

/*
 *	Options Window:
 */
typedef struct {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gboolean        processing;
	gint            busy_count,
			freeze_count;
	gpointer        core_ptr;

	gboolean	has_changes;

	gchar		*title;
	guint8		**icon_data;

	GtkWidget	*notebook;
	GtkWidget	**page;
	gint		total_pages;

	GtkWidget	*ok_btn,
			*apply_btn,
			*save_btn,
			*cancel_btn,
			*close_btn;

	optwin_wref_struct	**wref;
	gint			total_wrefs;

} optwin_struct;
#define OPTWIN(p)	((optwin_struct *)(p))


/* Wref Utilities */
extern optwin_wref_struct *OptWinWRefNew(
	GtkWidget *w,
	GtkWidget *browse,	/* Browse button */
	const gchar *cfg_parm,	/* Cfg item parameter */
	gpointer optwin
);
extern void OptWinWRefDelete(optwin_wref_struct *wref);
extern void OptWinWRefSetColorButton(
	optwin_wref_struct *wref, GtkWidget *color_btn
);
extern void OptWinWRefSetStyleEdit(
	optwin_wref_struct *wref, style_edit_struct *se
);
extern void OptWinWRefSetStackList(
	optwin_wref_struct *wref, stack_list_struct *slist
);
extern optwin_wref_struct *OptWinWRefAppend(
	optwin_struct *optwin,
	GtkWidget *w,
	GtkWidget *browse,	/* Browse button */
	const gchar *cfg_parm	/* Cfg item parameter */
);

/* Options Window */
extern optwin_struct *OptWinNew(
	gpointer core_ptr, const gchar *title, guint8 **icon_data
);
extern GtkWidget *OptWinPageAppend(
	optwin_struct *optwin, GtkWidget *w
);
extern void OptWinUpdateMenus(optwin_struct *optwin);
extern void OptWinSetBusy(optwin_struct *optwin, gboolean is_busy);
extern gboolean OptWinIsMapped(optwin_struct *optwin);
extern void OptWinMap(optwin_struct *optwin);
extern void OptWinUnmap(optwin_struct *optwin);
extern void OptWinDelete(optwin_struct *optwin);


#endif	/* OPTWIN_H */
