/*
		      Endeavour Mark II Core Structure
 */

#ifndef ENDEAVOUR_H
#define ENDEAVOUR_H

#include <gtk/gtk.h>

#include "cfg.h"
#include "pulist.h"
#include "edvtypes.h"
#include "edvid.h"
#include "edvcursor.h"
#include "edvdevices.h"
#include "edvmimetypes.h"
#include "browser.h"
#include "imbr.h"
#include "archiver.h"
#include "recbin.h"
#include "recbindeskicon.h"
#include "findwin.h"
#include "propdlg.h"
#include "historywin.h"
#include "rundlg.h"
#include "deviceswin.h"
#include "mimetypeswin.h"
#include "optwin.h"
#include "aboutdlg.h"


#ifdef HAVE_IMLIB
extern gpointer		imlib_handle;
#endif


/*
 *	Endeavour Core:
 */
typedef struct _edv_core_struct		edv_core_struct;
struct _edv_core_struct {

	/* Configuration */
        gchar			*cfg_file;
	cfg_item_struct		*cfg_list;

	/* Pixmaps List (list of edv_pixmaps) */
	GList			*pixmap_list;

	/* File Browsers */
	edv_browser_struct	**browser;
	gint			total_browsers;

	/* Image Browsers */
	edv_imbr_struct		**imbr;
	gint			total_imbrs;

	/* Archivers */
	edv_archiver_struct	**archiver;
	gint			total_archivers;

	/* Recycle Bin */
	edv_recbin_struct	*recbin;
	/* Recycle Bin Desktop Icon */
	edv_recbin_deskicon_struct	*recbin_deskicon;
	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not
	 */
	gint			last_recbin_items;

	/* Find Window */
	edv_findwin_struct	*findwin;

	/* Property Dialogs */
	edv_propdlg_struct	**propdlg;
	gint			total_propdlgs;

	/* History Window */
	edv_history_listwin_struct	*history_listwin;

	/* Run Dialog */
	edv_run_dlg_struct	*run_dlg;

	/* Devices Window */
	edv_device_listwin_struct	*device_listwin;

	/* MIME Types Window */
	edv_mimetype_listwin_struct	*mimetype_listwin;

	/* Options Window */
	optwin_struct		*options_window;

	/* Customize Window */
	optwin_struct		*customize_window;

	/* About Dialog */
	about_dlg_struct	*about_dlg;


	/* Basic GUI options */
	gboolean	geometry_set;
	GdkRectangle	geometry;	/* Only defined if geometry_set is TRUE */

	gchar		*font_name;
	GdkFont		*font;

	gchar		*fg_color_name, *bg_color_name,
			*sfg_color_name, *sbg_color_name,
			*cfg_color_name, *cbg_color_name,
			*bg_pixmap_path, *sbg_pixmap_path;
	gchar		*wm_name, *wm_class, *title;

	/* User defined GtkRcStyles (if not NULL) */
	GtkRcStyle	*standard_rcstyle,
			*lists_rcstyle;

	/* Timeout callback id and related members */
	guint		manage_toid;
	gboolean	need_close_all_windows,
			need_reset;

	/* InterPS signal count */
	gint		interps_signal_count;

        /* This process' ID */
        gint		pid; 

	/* This program object path (taken from command line) */
	gchar		*prog_file;

	/* Home directory */
	gchar		*home_dir;

	/* This process' user and group ID */
	gint		user_id;		/* Real user id */
	gint		effective_user_id;	/* Effective user id */
	gint		group_id;		/* Real group id */
	gint		effective_group_id;	/* Effective group id */

	/* User ID list */
	edv_uid_struct	**uid;
	gint		total_uids;
	pulist_struct	*users_pulist;

	/* Group id list */
	edv_gid_struct	**gid;
	gint		total_gids;
	pulist_struct	*groups_pulist;

	/* Verbose string describing (effective) "<username>" and
	 * "<username>@<hostname>"
	 *
	 * This is used for quick setting of title bars since the user
	 * and location do not change (often) at run time
	 */
	gchar	*effective_user_id_str;		/* user */
	gchar	*effective_user_id_host_str;	/* user@hostname */

	/* Cursors list */
	edv_cursor_struct	**cursor;
	gint			total_cursors;

	/* Devices list */
	edv_device_struct	**device;
	gint			total_devices;
	pulist_struct		*devices_pulist;	/* For mount bars */

	/* MIME Types list */
	edv_mimetype_struct	**mimetype;
	gint			total_mimetypes;
	pulist_struct		*openwith_pulist;	/* Lists application
							 * MIME Types for
							 * Open With
							 */

	/* MIME Types index hints
	 *
	 * These are index values of the first and last items of a
	 * particular MIME Type class in the list, these indices are
	 * updated in EDVDoUpdateMIMETypeHintIndices()
	 *
	 * These index values may not be valid, they should be only be
	 * used as reference
	 */
	gint		mimetype_system_index_first,
			mimetype_system_index_last;
	gint		mimetype_format_index_first,
			mimetype_format_index_last;
	gint		mimetype_program_index_first,
			mimetype_program_index_last;
	gint		mimetype_unique_index_first,
			mimetype_unique_index_last;

};
#define EDV_CORE(p)	((edv_core_struct *)(p))


extern edv_core_struct	*edv_core;


extern edv_core_struct *EDVNew(
	gint argc, gchar *argv[],
	gint *err_rtn
);
extern void EDVDelete(
	edv_core_struct *core_ptr, gboolean save_config
);


#endif	/* ENDEAVOUR_H */
