/*
				Status Bar
 */

#ifndef EDVSTATUSBAR_H
#define EDVSTATUSBAR_H

#include <gtk/gtk.h>


/*
 *	Status Bar:
 */
typedef struct _edv_status_bar_struct	edv_status_bar_struct;
struct _edv_status_bar_struct {

	GtkWidget	*toplevel;	/* GtkFrame */
	gint		busy_count,
			freeze_count;
	gpointer	core_ptr;

	GtkWidget	*write_protect_enabled_eb,
			*write_protect_disabled_eb,
			*delete_method_recycle_eb,
			*delete_method_purge_eb,
			*progress_bar,	/* GtkProgressBar */
			*label;		/* GtkLabel */

	gfloat		progress_pos_last;

};
#define EDV_STATUS_BAR(p)	((edv_status_bar_struct *)(p))


extern edv_status_bar_struct *EDVStatusBarNew(
	gpointer core_ptr, GtkWidget *parent
);
extern void EDVStatusBarUpdate(edv_status_bar_struct *sb);
extern void EDVStatusBarSetBusy(
	edv_status_bar_struct *sb, gboolean busy
);
extern void EDVStatusBarMap(edv_status_bar_struct *sb);
extern void EDVStatusBarUnmap(edv_status_bar_struct *sb);
extern void EDVStatusBarDelete(edv_status_bar_struct *sb);

extern void EDVStatusBarMessage(
	edv_status_bar_struct *sb, const gchar *message,
	gboolean allow_gtk_iteration
);
extern void EDVStatusBarProgress(
	edv_status_bar_struct *sb, gfloat percent,
	gboolean allow_gtk_iteration
);


#endif	/* VMASTATUSBAR_H */
