/*
		     Recycle Bin Types and IO
 */

#ifndef EDVRECBIN_H
#define EDVRECBIN_H

#include <glib.h>
#include "edvtypes.h"
#include "edvobj.h"



/*
 *	Recycled object structure:
 */
typedef struct {

	/* Original name of object */
	gchar		*name;

	/* Full path to original location, without the object's name */
	gchar		*original_path;

	/* Recycled object index number, this will be formatted into
	 * a string and matches an object of type file in the recycled 
	 * objects directory
	 */
	guint		index;

	/* Systime of when this object was originally deleted */
	gulong		date_deleted;


	/* Following are original statistics of the object */

	gint		type;		/* One of EDV_OBJECT_TYPE_* */

	gchar		*linked_to;	/* Link destination, only for type
					 * EDV_OBJECT_TYPE_LINK
					 */

	edv_permission_flags permissions;	/* Any of EDV_PERMISSION_* */

	gulong		access_time,	/* In systime seconds */
			modify_time,
			change_time;

	gint		owner_id,
			group_id;

	gulong		size;	/* Original size of the object in bytes,
				 * this applies only to objects of type
				 * EDV_OBJECT_TYPE_FILE
				 */

} edv_recbin_object_struct;
#define EDV_RECBIN_OBJECT(p)	((edv_recbin_object_struct *)(p))


extern gchar *EDVRecBinGetDirectoryFromIndexPath(const gchar *filename);

extern edv_recbin_object_struct *EDVRecBinObjectNew();
extern edv_recbin_object_struct *EDVRecBinObjectCopy(
	const edv_recbin_object_struct *obj
);
extern void EDVRecBinObjectDelete(
	edv_recbin_object_struct *obj
);


#endif	/* EDVRECBIN_H */
