#include <gtk/gtk.h>
#include "guiutils.h"
#include "edvcursor.h"
#include "config.h"


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates a new cursor based on the given GDK cursor type code.
 */
edv_cursor_struct *EDVCursorNewByGDKPreset(
	gint cursor_code, GdkCursorType gdk_cursor_type
)
{
	edv_cursor_struct *cur = EDV_CURSOR(
	    g_malloc0(sizeof(edv_cursor_struct))
	);
	if(cur == NULL)
	    return(cur);

	cur->code = cursor_code;
	cur->cursor = gdk_cursor_new(gdk_cursor_type);

	return(cur);
}

/*
 *	Destroys all resources for the given cursor and deallocates the
 *	structure itself.
 */
void EDVCursorDelete(edv_cursor_struct *cur)
{
	if(cur == NULL)
	    return;

	GDK_CURSOR_DESTROY(cur->cursor);
	g_free(cur);
}
