/*
		      Endeavour Browser Operation Callbacks
 */

#ifndef BROWSEROPCB_H
#define BROWSEROPCB_H


#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvdevices.h"
#include "browser.h"


extern void EDVBrowserMenuItemCB(GtkWidget *widget, gpointer data);
extern gint EDVBrowserMenuItemEnterCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVBrowserMenuItemLeaveCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

extern void EDVBrowserOPCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVBrowserOPEnterCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVBrowserOPLeaveCB(
	toolbar_item_struct *item, gint id, gpointer data
);

extern void EDVBrowserMountBarMountCB(
	gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
	gpointer data
);
extern void EDVBrowserMountBarEjectCB(
	gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
	gpointer data
);
extern void EDVBrowserMountBarGoToCB(
	gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
	gpointer data
);

extern gchar *EDVBrowserFindBarLocationCB(gpointer fb, gpointer data);
extern void EDVBrowserFindBarStartCB(gpointer fb, gpointer data);
extern void EDVBrowserFindBarEndCB(
	gpointer fb, gint total_matches, gpointer data
);
extern void EDVBrowserFindBarMatchCB(
	const gchar *path, const struct stat *lstat_buf,
	const gchar *excerpt, gint line_index,
	gpointer data
);

extern void EDVBrowserBarStatusMessageCB(
	gpointer mb, const gchar *message, gpointer data
);
extern void EDVBrowserBarStatusProgressCB(
	gpointer bar, gfloat progress, gpointer data
);

extern void EDVBrowserOPSyncDisks(edv_browser_struct *browser);
extern void EDVBrowserOPWriteProtect(edv_browser_struct *browser);

extern void EDVBrowserOPClose(edv_browser_struct *browser);
extern void EDVBrowserOPExit(edv_browser_struct *browser);

extern void EDVBrowserOPNewObject(edv_browser_struct *browser);
extern void EDVBrowserOPNewFile(edv_browser_struct *browser);
extern void EDVBrowserOPNewDirectory(edv_browser_struct *browser);
extern void EDVBrowserOPNewLink(edv_browser_struct *browser);
extern void EDVBrowserOPNewFifo(edv_browser_struct *browser);
extern void EDVBrowserOPNewDeviceBlock(edv_browser_struct *browser);
extern void EDVBrowserOPNewDeviceCharacter(edv_browser_struct *browser);
extern void EDVBrowserOPNewSocket(edv_browser_struct *browser);

extern void EDVBrowserOPOpen(edv_browser_struct *browser);
extern void EDVBrowserOPOpenWith(edv_browser_struct *browser);

extern void EDVBrowserOPGoToParent(edv_browser_struct *browser);
extern void EDVBrowserOPExpand(edv_browser_struct *browser);
extern void EDVBrowserOPMount(edv_browser_struct *browser);

extern void EDVBrowserOPMove(edv_browser_struct *browser);
extern void EDVBrowserOPCopy(edv_browser_struct *browser);
extern void EDVBrowserOPLink(edv_browser_struct *browser);
extern void EDVBrowserOPRename(edv_browser_struct *browser);
extern void EDVBrowserOPChMod(edv_browser_struct *browser);
extern void EDVBrowserOPChown(edv_browser_struct *browser);
extern void EDVBrowserOPDelete(edv_browser_struct *browser);
extern void EDVBrowserOPProperties(edv_browser_struct *browser);

extern void EDVBrowserOPCopyPath(edv_browser_struct *browser);
extern void EDVBrowserOPCopyURL(edv_browser_struct *browser);        

extern void EDVBrowserOPDownload(edv_browser_struct *browser);

extern void EDVBrowserOPRefresh(edv_browser_struct *browser);
extern void EDVBrowserOPRefreshAll(edv_browser_struct *browser);

extern void EDVBrowserOPDirectoryTreeOrigin(edv_browser_struct *browser);


#endif	/* BROWSEROPCB_H */
