/*
		 Endeavour Recycle Bin Contents List
 */

#ifndef ARCHIVERCONTENTS_H
#define ARCHIVERCONTENTS_H

#include <sys/stat.h>
#include <gtk/gtk.h>
#include "edvarchobj.h"
#include "archiver.h"


extern gint EDVArchiverContentsFindRowByPath(
	edv_archiver_struct *archiver, const gchar *path
);

extern void EDVArchiverContentsResetRows(edv_archiver_struct *archiver);
extern void EDVArchiverContentsDoUpdate(
	edv_archiver_struct *archiver, gboolean update_status_bar
);

extern void EDVArchiverContentsObjectModifiedNotify(
	edv_archiver_struct *archiver, const gchar *path,
	const gchar *new_path, const struct stat *lstat_buf
);
extern void EDVArchiverContentsObjectRemovedNotify(
	edv_archiver_struct *archiver, const gchar *path
);

extern void EDVArchiverContentsArchiveObjectAddedNotify(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path, edv_archive_object_struct *obj
);
extern void EDVArchiverContentsArchiveObjectModifiedNotify(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path, const gchar *new_path,
	edv_archive_object_struct *obj
);
extern void EDVArchiverContentsArchiveObjectRemovedNotify(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path
);



#endif	/* ARCHIVERCONTENTS_H */
