# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.core import common
from elisa.core.plugin_registry import PluginNotFound, ComponentNotFound
from elisa.core import plugin_registry

from elisa.core.media_uri import MediaUri

from elisa.extern.translation import gettexter, N_
T_ = gettexter('elisa-aspect-ratio-switcher')


MenuActivityClass = plugin_registry.get_component_class('base:menu_activity')
from switch_aspect_ratio_action import SwitchAspectRatioAction

class AspectRatioSwitcherActivity(MenuActivityClass):
    """
    DOCME
    """

    config_doc = {'aspect_ratios': "a list of aspect ratio like '16:9' or 'auto'"}
    default_config = {'aspect_ratios': []}

    menu_name = T_(N_("Screen type"))
    menu_icon_name = "aspect_ratio_switcher"
    media_types = []

    default_ratios = ['auto', '4:3', '16:9', '16:10']

    def get_model(self):
        """
        Returns a menu_node_model for the aspect_ratios menu
        """
        main_node = MenuActivityClass.get_model(self)

        # create the default ratio items
        for aspect_ratio in self.default_ratios:
            menu_model = self._model_from_ratio(aspect_ratio)

            if menu_model != None:
                self.log("menu model: %r", menu_model)
                main_node.append(menu_model)
            else:
                self.debug("error when creating menu_model %s", aspect_ratio)

        for aspect_ratio in self.config.get("aspect_ratios", []):
            if aspect_ratio in self.default_ratios:
                continue

            menu_model = self._model_from_ratio(aspect_ratio)

            if menu_model != None:
                self.log("menu model: %r", menu_model)
                main_node.append(menu_model)
            else:
                self.debug("error when creating menu_model %s", aspect_ratio)

        main_node.has_children = len(main_node) > 0

        return main_node

    def _model_from_ratio(self, aspect_ratio):
        self.log("Creating aspect ratio menu model %s", aspect_ratio)

        icon_name = "ratio_" + aspect_ratio.replace(":", "_")

        if aspect_ratio == 'auto':
            label = T_(N_('Automatic'))
        elif aspect_ratio == 'mm':
            label = T_(N_('Use screen size'))
        else:
            label = aspect_ratio

        menu_model = self._create_menu_model(label, icon_name)
        action = SwitchAspectRatioAction()
        action.aspect_ratio = aspect_ratio
        menu_model.activate_action = action

        return menu_model
