# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'

from menu_activity import MenuActivity
from elisa.core.common import application
from elisa.core.plugin_registry import PluginNotFound, ComponentNotFound

class MainMenuActivity(MenuActivity):

    config_doc = {'menu_activities': 'Activities that can provide a MenuModel'}
    default_config = {'menu_activities': ['base:audio_activity',
                                          'base:video_activity']}

    slideshow_model = None
    player_model = None
    dvd_player_model = None

    def __init__(self):
        MenuActivity.__init__(self)
        self._menu_activities = []

    def get_model(self):
        registry = application.plugin_registry
        model = registry.create_component('base:menu_model')
        model.id = 'root'
        model.text = 'menu_root'
        model.theme_icon = ''

        # retrieve component names from config and there MenuModel
        activities = self.config.get('menu_activities', [])
        for activity_path in activities:
            activity = self._create_activity(activity_path)
            if activity:
                menu_model = activity.get_model()
                self._menu_activities.append(activity)

                self.log("Component %r with menu model %r", activity, menu_model)
                model.append(menu_model)

        model.has_children = len(model) > 0
        model.activity = self
        return model

    def save_config(self, app_config):
        for activity in self._menu_activities:
            activity.save_config(app_config)
        MenuActivity.save_config(self, app_config)
