# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'

from elisa.core import plugin_registry
TreeControllerClass = plugin_registry.get_component_class('base:tree_controller')

from elisa.core.input_event import *

from twisted.internet import reactor

class TreeController(TreeControllerClass):

    supported_models = ('base:menu_model', 'base:menu_node_model')

    default_associations = (
    ('base:menu_node_model','poblenou:node_controller'),
    )

    def __init__(self):
        TreeControllerClass.__init__(self)
        self.selected_controller = self
        self._root = self
        self._call_later = None
        

    def handle_input(self, input_event):
        
        if input_event.action == EventAction.GO_DOWN:
            self.enter_node()
            return True

        elif input_event.action == EventAction.GO_LEFT:
            self._go_left()
            return True

        elif input_event.action == EventAction.GO_RIGHT:
            self._go_right()
            return True

        elif input_event.action == EventAction.OK:
            if self.current_index >= 0 and self.current_index < len(self):
                child_controller = self[self.current_index]
                if callable(child_controller.model.activate_action):
                    child_controller.model.activate_action(self, input_event.origin)
                else:
                    self.enter_node()
            return True

        elif input_event.value == EventValue.KEY_m:
            # switch to the next visualisation mode
            current = self._visualisation_modes.index(self.visualisation_mode)
            current = (current + 1) % len(self._visualisation_modes)
            self.visualisation_mode = self._visualisation_modes[current]

            return True

        return False


    def _go_left(self):
        if len(self) > 0:
            self.current_index = (self.current_index - 1) % len(self)
                
                
    def _go_right(self):
        if len(self) > 0:
            self.current_index = (self.current_index + 1) % len(self)
                
    def enter_node(self):
        if len(self) == 0:
            return

        child_controller = self[self.current_index]
        if child_controller.model.has_children:
            child_controller.loadmore()
            child_controller.focus()
            child_controller.selected = True

            if self.loadmore_on_selection == True and len(child_controller) > 0:
                grand_child_controller = child_controller[child_controller.current_index]
                if grand_child_controller.model.has_children:
                    grand_child_controller.loadmore()
