# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'

from pypgmtools.graph.image import Image
from pypgmtools.graph.group import Group
from pypgmtools.widgets.volume_osd import VolumeOsd
from pypgmtools.widgets.player_osd import *
from twisted.internet import reactor
from elisa.core import player, common

from elisa.extern.translation import gettexter, N_
T_ = gettexter('elisa-poblenou-frontend')


import pygst
pygst.require('0.10')
import gst, pgm

from elisa.core import plugin_registry
DvdPlayerViewClass = plugin_registry.get_component_class('dvd:dvd_player_view')
from elisa.plugins.bad.dvd.dvd_player_view import FLUENDO_DVD_INSTALLED

class DvdPlayerView(DvdPlayerViewClass):
    supported_controllers = ('dvd:dvd_player_controller')

    def initialize(self):
        DvdPlayerViewClass.initialize(self)
        self.context_path = "pigment:pigment_context"
        self.background = Image()
        self.background.position = (0.0, 0.0, 0.0)
        self.background.size = (4.0, 3.0)
        self.background.bg_color = (0, 0, 0, 0)
        self.background.opacity = 255
        self.background.visible = True
        self.player_dock = None
        self.group = None
        
        #FIXME you can't put _create_player here because
        #drawable have to be added to the canvas before using it 
        #in a pipeline
        #self._create_player()
        
        
    def _create_player(self):

        if FLUENDO_DVD_INSTALLED:
            vsink = gst.parse_bin_from_description ( \
                    "ffmpegcolorspace ! pgmimagesink name=pgm_sink qos=false max-lateness=-1", True)
            
            pgm_sink = vsink.get_by_name('pgm_sink')
            pgm_sink.set_property('image', self.background)
            self.player.video_sink = vsink
        else:
            video_sink = gst.element_factory_make('pgmimagesink')
            video_sink.set_property('image', self.background)
            self.player.video_sink = video_sink


    def frontend_changed(self, previous_frontend, new_frontend):
        if new_frontend == None:
            return

        DvdPlayerViewClass.frontend_changed(self, previous_frontend, new_frontend)

        if self.group == None:
            # create the group
            canvas = self.frontend.context.viewport_handle.get_canvas()
            self.group = Group(canvas, pgm.DRAWABLE_MIDDLE)
            self.context_handle = self.group

            dock_bg_path = self.frontend.theme.get_media("dock_background")
            dock_bar_bg_path = self.frontend.theme.get_media("dock_bar_bg")
            dock_bar_fg_path = self.frontend.theme.get_media("dock_bar_fg")

            px, py = 0.7, 0.8
            iw, ih = 4.0, 3.0
            
            self.player_dock = PlayerOsd(canvas,
                                         pgm.DRAWABLE_NEAR,
                                         10000,
                                         iw*px, ih*0.15,
                                         dock_bar_bg_path,
                                         dock_bar_fg_path,
                                         dock_bg_path)

            self.player_dock.position = ((1-px)*iw/2.0, ih*py, 0.0)

            self.player_dock.opacity = 0
            self.player_dock.visible = True


            # FIXME: not yet working. Anyone knows why?
            trans = common.application.translator
            volume_name = trans.translateTranslatable(T_(N_("Volume: %s%%")),
                                        self.frontend.languages)

            vol_bg_path = self.frontend.theme.get_media("vol_dock_background")
            self.volume_dock = VolumeOsd(canvas,
                                         pgm.DRAWABLE_NEAR,
                                         volume_name,
                                         iw*0.3, ih*0.1,
                                         vol_bg_path)
            self.volume_dock.position = (0.15, 0.10, 0)
            self.volume_dock.opacity = 0
            self.volume_dock.visible = True



            self.group.add(self.background)
            self.group.visible = True
            
            self._create_player()

    def uri_changed(self, uri):
        self.player_dock.title = uri.label


    def volume_changed(self, value):
        self.volume_dock.volume = value * 10.
        if self.controller.state == player.STATES.PLAYING and \
               self.controller.focused:
            self.volume_dock.show()


    def state_changed(self, state):
        DvdPlayerViewClass.state_changed(self, state)
        if state == player.STATES.PAUSED:
            self.player_dock.show()
        elif state == player.STATES.STOPPED:
            self.background.clear()

        # FIXME: this whole refresh_dock looks hackish
        reactor.callLater(0.05, self.refresh_dock)


    def seek_to_changed(self, position):
        DvdPlayerViewClass.seek_to_changed(self, position)
        self.player.seek_to_location(position)
        self.player_dock.time = self.player.position / 1000000.00
        self.player_dock.show()

    def refresh_dock(self):
        # FIXME: a division in a code called every 50 ms is not good
        duration = int(self.player.duration / 1000000)
        self.player_dock.playing_length = duration

        self.player_dock.time = self.player.position / 1000000.0

        if self.controller.state == player.STATES.PLAYING:
            reactor.callLater(0.05, self.refresh_dock)
