# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding image example
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Author: Loïc Molinari <loic@fluendo.com>


import pygtk
pygtk.require('2.0')

import pygst
pygst.require('0.10')

import gst
from elisa.core.media_uri import MediaUri
import sys, os, pgm, gobject
from dvd_player import *
gobject.threads_init() 

# Update the viewport on an expose event
def on_expose(viewport, event):
    viewport.update()

# Terminate the mainloop on a delete event
def on_delete(viewport, event):
    pgm.main_quit()


def on_key_pressed(port, event, player):
    if event.type == pgm.KEY_PRESS:
        if event.keyval == pgm.keysyms.Escape or \
                event.keyval ==  pgm.keysyms.q:
            pgm.main_quit()

        elif event.keyval == pgm.keysyms.m:
            player.fire_action(DVD_ACTION_MENU_ROOT_OR_RESUME)
        elif event.keyval == pgm.keysyms.Up:
            player.fire_action(DVD_ACTION_BUTTON_UP)
        elif event.keyval == pgm.keysyms.Down:
            player.fire_action(DVD_ACTION_BUTTON_DOWN)
        elif event.keyval == pgm.keysyms.Right:
            player.fire_action(DVD_ACTION_BUTTON_RIGHT)
        elif event.keyval == pgm.keysyms.Left:
            player.fire_action(DVD_ACTION_BUTTON_LEFT)
        elif event.keyval == pgm.keysyms.Return:
            player.fire_action(DVD_ACTION_BUTTON_ACTIVATE)
        elif event.keyval == pgm.keysyms.r:
            player.fire_action(DVD_R)
            
def main(args):
    # OpenGL viewport creation
    factory = pgm.ViewportFactory('opengl')
    gl = factory.create()
    gl.title = 'Image'

    # Canvas and image drawable creation
    cvs = pgm.Canvas()
    gl.set_canvas(cvs)

    img = pgm.Image()
    
    # Load an image from a file descriptor
    #fd = os.open('fluendo.png', os.O_RDONLY)
    #img.set_from_fd(fd)
    img.bg_color = (255, 255, 255, 0)

    # Center the image
    img.position = (0.0, 0.0, 0.0)
    img.size = (4.0, 3.0)

    # A drawable needs to be shown
    img.show()
    
    # Add it to the middle layer of the canvas
    cvs.add(pgm.DRAWABLE_MIDDLE, img)

    # Let's connect our callbacks and start the mainloop
    gl.connect('expose-event', on_expose)
    gl.connect('delete-event', on_delete)
            
    gl.show()
    gl.update()
    
    if len(args) > 0:
        path = args[0]
    else:
        path = 'dvd://'
    
    player = ElisaDVDPlayer()
    vsink = gst.parse_bin_from_description ( \
                    "ffmpegcolorspace ! pgmimagesink name=pgm_sink qos=false max-lateness=-1", True)
    
    img.set_from_fd(os.open('elisa/plugins/dvd/fluendo.png', os.O_RDONLY))    
    pgm_sink = vsink.get_by_name('pgm_sink')
    pgm_sink.set_property('image', img)
    player.video_sink = vsink
    
    player.load_uri(MediaUri(path))
    player.play()
    gobject.timeout_add(35, gl.update)
    gl.connect('key-press-event', on_key_pressed, player)
    pgm.main()

if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
