# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest
from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core.utils import signal

class TestSignal(ElisaTestCase):

    def test_emit(self):
        """
        Create a signal, connect a function to it and emit it.
        """
        def test(number, text):
            self.assertEquals(number, 42)
            self.assertEquals(text, "boudiou")
            test.called = True

        test.called = False

        signal1 = signal.Signal('test-signal',int, object)
        signal1.connect(test)

        signal1.emit(42, "boudiou")
        self.assertEquals(test.called, True)

    def test_wrong_argument(self):
        def test(number, text, foo=0):
            self.assertEquals(number, 42)
            self.assertEquals(text, "boudiou")
            self.assertEquals(foo, 0)
            test.called = True

        test.called = False

        signal1 = signal.Signal('test-signal', int, object, foo=int)
        signal1.connect(test)

        signal1.emit(42, "boudiou")
        self.assertEquals(test.called, True)

        self.assertRaises(signal.WrongArgument, signal1.emit, 42, "bar",
                          foo="bar")

    def test_non_callable(self):
        signal1 = signal.Signal('test-signal', int, object)
        self.assertRaises(TypeError, signal1.connect, object())

    def test_disconnect(self):
        def test(number, text):
            self.assertEquals(number, 42)
            self.assertEquals(text, "boudiou")
            test.called = True

        test.called = False

        signal1 = signal.Signal('test-signal',int, object)
        signal1.connect(test)
        signal1.disconnect(test)

        signal1.emit(42, "boudiou")
        self.assertEquals(test.called, False)

