# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest
from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core import common, player_engine_registry, plugin
from elisa.base_components import player_engine

class FooEngine(player_engine.PlayerEngine):
    uri_schemes = {'foo' : 150, 'test' : 100, 'test2' : 50 }

class BarEngine(player_engine.PlayerEngine):
    uri_schemes = {'bar' : 150, 'test' : 50, 'test2' : 100 }

class GooEngine(player_engine.PlayerEngine):
    uri_schemes = {'goo' : 150}

class FooPlugin(plugin.Plugin):
    name = 'foo'
    components = {'foo_eng': {'path':FooEngine},
                  'goo_eng': {'path':GooEngine}
                  }

class BarPlugin(plugin.Plugin):
    name = 'bar'
    components = {'bar_eng': {'path':BarEngine}}


class TestPlayerEngineRegistry(ElisaTestCase):

    def setUp(self):
        ElisaTestCase.setUp(self)

        # Silly
        from elisa.core.common import application
        registry = application.plugin_registry
        registry.register_plugin(FooPlugin)
        registry.register_plugin(BarPlugin)

        application.config.set_option('player_engines', 
                ['bar:bar_eng', 'foo:foo_eng', 'foo:goo_eng'])

        self._en_reg = player_engine_registry.PlayerEngineRegistry()
        self._en_reg.initialize()
   
    def test_engine_creating(self):
        plug_reg = common.application.plugin_registry

        test = self._en_reg.create_engine_for_scheme('test')
        self.assertEquals(type(test),
                        plug_reg.get_component_class('bar:bar_eng'))


        try:
            bad = self._en_reg.create_engine_for_scheme('this_scheme_does_not_exist!')
            self.assertFalse(True)
        except player_engine_registry.NoEngineFound:
            self.assertFalse(False)
            
        test2 = self._en_reg.create_engine_for_scheme('test2')
        self.assertEquals(type(test2),
                        plug_reg.get_component_class('foo:foo_eng'))

        goo = self._en_reg.create_engine_for_scheme('goo')
        self.assertEquals(type(goo),
                        plug_reg.get_component_class('foo:goo_eng'))

