# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core.observers.observable import Observable
from elisa.core.observers.list import ListObservable
from elisa.core.observers.observer import Observer
from twisted.internet import defer


class MyObserver(Observer):

    def __init__(self):
        Observer.__init__(self)
        self.called = False

    def attribute_set(self, key, old_value, new_value):
        self.called = True

class MyObserverRaisingException(Observer):

    def __init__(self):
        Observer.__init__(self)

    def attribute_set(self, key, old_value, new_value):
        raise Exception()


class MyListObserver(Observer):

    def __init__(self):
        Observer.__init__(self)
        self.inserted_called = False
        self.removed_called = False
        self.modified_called = False
        self.dirtied_called = False

    def inserted(self, elements, position):
        self.inserted_called = True

    def removed(self, elements, position):
        self.removed_called = True

    def modified(self, key, value):
        self.modified_called = True

    def dirtied(self):
        self.dirtied_called = True


class TestObservers(ElisaTestCase):

    def test_observable(self):
        observer = MyObserver()
        o = Observable()

        observer.observe(o)

        o.test = "test"

        self.failUnless(observer.called == True)

    def test_reattach(self):
        observer = MyObserver()
        o1 = Observable()
        o2 = Observable()

        observer.observe(o1)
        observer.observe(o2)

        o1.test = "test"
        self.failUnless(observer.called == False)
        o2.test = "test"
        self.failUnless(observer.called == True)

    def test_exception(self):
        observer = MyObserverRaisingException()
        o = Observable()

        observer.observe(o)

        self.failUnlessRaises(Exception, o.__setattr__, "test", "test")

    def test_list_append(self):
        l = ListObservable()
        observer = MyListObserver()
        s = "test"
        observer.observe(l)

        l.append(s)
        self.failUnless(observer.inserted_called)

        l.pop()
        self.failUnless(observer.removed_called)

        l.append(s)
        l[0] = "test2"
        self.failUnless(observer.modified_called)

        l.reverse()
        self.failUnless(observer.dirtied_called)
