# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.base_components.model import Model
from elisa.base_components.controller import Controller
from elisa.base_components.controller import ModelNotSupported

class FooModel(Model):
    def __init__(self):
        Model.__init__(self)

        self.string_test = "test"
        self.path = "none:foo_model"

class NonFooModel(Model):
    def __init__(self):
        Model.__init__(self)

        self.string_test = "toto"
        self.path = "none:nonfoo_model"

class FooController(Controller):

    supported_models = ("none:foo_model",)

    def __init__(self):
        Controller.__init__(self)
        self.changed = False

    def model_changed(self, old_model, new_model):
        self.changed = True


class TestController(ElisaTestCase):

    def setUp(self):
        ElisaTestCase.setUp(self)
        self._foo = FooController()

    def test_model_changed(self):
        model = FooModel()
        self._foo.model = model
        self.failUnless(self._foo.changed)

        self._foo.changed = False

        self._foo.model = model
        self.failUnlessEqual(self._foo.changed, False)

        self._foo.changed = False

        model = FooModel()
        self._foo.model = model
        self.failUnless(self._foo.changed)


    def test_supported_models(self):
        self.assertEquals(type(self._foo.supported_models), tuple)
        for s in self._foo.supported_models:
            self.assertEquals(type(s), str)

        model = FooModel()
        self._foo.model = model

        model = NonFooModel()
        self.failUnlessRaises(ModelNotSupported, self._foo.model__set, model)
