# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from observable import Observable
from observer import Observer

class DictObservable(Observable, dict):

    # FIXME: this class and the dict should be made thread-safe
    # FIXME: not complete.

    def __init__(self, *args, **kw):
        dict.__init__(self, *args, **kw)
        Observable.__init__(self)

    def __hash__(self):
        return Observable.__hash__(self)

    def __repr__(self):
        return "<DictObservable %r>" % dict.__repr__(self)

    def __eq__(self, other):
        return id(self) == id(other)

    def __setitem__(self, key, value):
        dict.__setitem__(self, key, value)
        for observer in self._observers:
            observer.modified(key, value)

class DictObserver(Observer):

    def modified(self, key, value):
        print "%s set to %s" % (key, value)
        raise NotImplementedError("method modified not implemented by %r" % type(self))


if __name__ == "__main__":

    l = DictObservable()
    o = DictObserver()

    o.observe(l)

    print l
    l['key']= 'value'
    l['key']= 'value2'
