
import sys, os
import pexpect

def execute(command, expected_string='', input_string=''):
    print command
    if input_string:
        child = pexpect.spawn(command)
        child.expect(expected_string)
        child.sendline(input_string)
        data = child.read()
        child.close()
    else:
        f = os.popen(command, 'r')
        data = f.read()
        f.close()
    return data


def get_pot_files(dirname):
    return execute('find %s -name "*.pot"' % dirname).splitlines()

def msginit(pot_file, email, lang):
    dirname = os.path.dirname(pot_file)
    out_file = os.path.join(dirname, "%s.po" % lang)
    cmd = 'msginit --input %s --locale %s --output %s' % (pot_file, lang,
                                                          out_file)
    if email:
        execute(cmd, 'enter your email address.', email)
    else:
        execute(cmd)

    return out_file

def msgmerge(pot_file, lang):
    dirname = os.path.dirname(pot_file)
    po_file = os.path.join(dirname, "%s.po" % lang)
    execute('msgmerge -U %s %s' % (po_file, pot_file))
    # TODO: find a way to detect the .po file was updated or not.
    return out_file

def usage():
    prog = sys.argv[0]
    print """\
usage: %s init|update email langugage code

To find the language code, go hunt it at http://www.sil.org/iso639-3/codes.asp

example: %s init foo@bar.com ita
""" % (prog, prog)

def main(args):
    if len(args) != 3:
        return usage()
    
    operation = args[0]
    email = args[1]
    lang = args[2]

    main_dir = 'elisa'
    if operation == 'init':
        for pot_file in get_pot_files(main_dir):
            new_po = msginit(pot_file, email, lang)
            print 'new po file to translate: %s' % new_po
    elif operation == 'update':
        for pot_file in get_pot_files(main_dir):
            updated_po = msgmerge(pot_file, lang)
        
    return 0


if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
