import sys
import os

try:
    import epydoc
    from epydoc import cli
except ImportError:
    print 'Epydoc needed to build the API documentation, please install it'
    sys.exit(1)

packages = 'elisa'

if len(sys.argv) > 1:
    OPTIONS = '%s %s' % (sys.argv[-1], packages)
else:
    OPTIONS = ''

def build_doc_for_stable_epydoc():
    if OPTIONS:
        options = OPTIONS
    else:
        css = 'data/epydoc.css'
        #css = 'blue'
        options = '-v --html --css %s -o docs/api %s' % (css,packages)
    args = options.split(' ')
    epydocify(args)

def build_doc_for_new_epydoc():
    if OPTIONS:
        options = OPTIONS
    else:
        options = '-v --html -o docs/api --graph=all %s' % packages
    args = options.split(' ')
    epydocify(args)

def epydocify(args):
    prog = sys.argv[0]
    sys.argv = [prog, ]
    sys.argv.extend(args)
    cli.cli()

def clean():
    # TODO: use os.unlink
    os.system('rm -rf docs/api/*')

def main(*args):
    clean()

    epydoc_version = epydoc.__version__.split('.')
    if int(epydoc_version[0]) < 3:
        build_doc_for_stable_epydoc()
    else:
        print 'Using Epydoc 3'
        build_doc_for_new_epydoc()

if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
