/*
 * Decompiled with CFR 0.152.
 */
package dumphd.util;

import dumphd.util.ByteSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamSource
implements ByteSource {
    private InputStream is = null;
    private OutputStream os = null;
    private File dummyFile = null;
    private boolean closeable = true;

    public StreamSource(Object source, int mode, boolean closeable) {
        this.closeable = closeable;
        switch (mode) {
            case 0: {
                if (source instanceof InputStream) {
                    this.is = (InputStream)source;
                    this.dummyFile = new File("InputStreamSource");
                    break;
                }
                throw new IllegalArgumentException("StreamSource: Read mode requested but given stream is not an InputStream");
            }
            case 1: {
                if (source instanceof OutputStream) {
                    this.os = (OutputStream)source;
                    this.dummyFile = new File("OutputStreamSource");
                    break;
                }
                throw new IllegalArgumentException("StreamSource: Write mode requested but given stream is not an OutputStream");
            }
            default: {
                throw new IllegalArgumentException("StreamSource: Unsupported mode argument");
            }
        }
    }

    @Override
    public int read(byte[] dst, int offset, int length) throws IOException {
        if (this.is != null) {
            int totalRead = 0;
            int read = 0;
            while ((read = this.is.read(dst, offset, length)) != -1) {
                totalRead += read;
            }
            return totalRead;
        }
        throw new IllegalStateException("StreamSource: This object has not been created in reading mode");
    }

    @Override
    public int write(byte[] src, int offset, int length) throws IOException {
        if (this.os != null) {
            this.os.write(src, offset, length);
            return length;
        }
        throw new IllegalStateException("StreamSource: This object has not been created in writing mode");
    }

    @Override
    public long size() throws IOException {
        return 0L;
    }

    @Override
    public long getPosition() throws IOException {
        return 0L;
    }

    @Override
    public void setPosition(long position) throws IOException {
        throw new UnsupportedOperationException("StreamSource: Seeking is not supported");
    }

    @Override
    public int windowCount() {
        return 0;
    }

    @Override
    public void addWindow(long size) throws IOException {
        throw new UnsupportedOperationException("StreamSource: Windows are not supported");
    }

    @Override
    public void removeWindow() throws IOException {
        throw new UnsupportedOperationException("StreamSource: Windows are not supported");
    }

    @Override
    public int getMode() {
        if (this.is == null) {
            return 1;
        }
        if (this.os == null) {
            return 0;
        }
        return 2;
    }

    @Override
    public File getFile() {
        return this.dummyFile;
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        if (this.closeable) {
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (IOException e) {
                    exception = e;
                }
            }
        }
        this.is = null;
        this.os = null;
        if (exception != null) {
            throw exception;
        }
    }
}

