/*
 * Decompiled with CFR 0.152.
 */
package dumphd.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleFilenameFilter
implements FilenameFilter {
    private Pattern filenamePattern = null;
    private boolean invert = false;

    public SimpleFilenameFilter(String pattern, boolean caseInsensitive, boolean invert) {
        this.invert = invert;
        this.filenamePattern = caseInsensitive ? Pattern.compile(pattern, 66) : Pattern.compile(pattern);
    }

    @Override
    public boolean accept(File dir, String name) {
        if (new File(dir, name).isDirectory()) {
            return true;
        }
        Matcher matcher = this.filenamePattern.matcher(name);
        return matcher.matches() ^ this.invert;
    }
}

