#!/bin/sh

if [ $# -lt 3 ]; then 
	echo "Usage: $0 <xen id> <hdd size> <swap size> [lvm/vbd]"
	exit
fi

# Things that often change

# Source the configuration in the config file!
. /etc/dtc-xen/dtc_create_vps.conf.sh

# Things that might change
# LVMNAME=lvm1
VPSGLOBPATH=${VPS_MOUNTPOINT}

# Things that most of then time don't change
VPSNUM=$1
VPSNAME=xen${VPSNUM}
VPSHOSTNAME=xen${NODE_NUM}${VPSNUM}
VPSHDD=$2
VPSMEM=$3
IMAGE_TYPE=$4

# redirect stdout and stderr to log files, so we can see what happened during install

echo "Redirecting standard output to $VPSGLOBPATH/$VPSNUM.stdout..."
echo "Redirecting standard error to $VPSGLOBPATH/$VPSNUM.stderr..."
if [ -e $VPSGLOBPATH/$VPSNUM.setuplvm.stdout ]; then
        mv $VPSGLOBPATH/$VPSNUM.setuplvm.stdout $VPSGLOBPATH/$VPSNUM.setuplvm.stdout.old
fi
if [ -e $VPSGLOBPATH/$VPSNUM.setuplvm.stderr ]; then
        mv $VPSGLOBPATH/$VPSNUM.setuplvm.stderr $VPSGLOBPATH/$VPSNUM.setuplvm.stderr.old
fi

exec 1>$VPSGLOBPATH/$VPSNUM.setuplvm.stdout
exec 2>$VPSGLOBPATH/$VPSNUM.setuplvm.stderr


if [ -z ""$IMAGE_TYPE ]; then
	IMAGE_TYPE=lvm
fi

LVCREATE=/sbin/lvcreate
LVREMOVE=/sbin/lvremove
MKFS=/sbin/mkfs.ext3
MKDIR=/bin/mkdir
MKSWAP=/sbin/mkswap

echo "Seleted ${VPSNAME}: ${VPSHDD}MB HDD and ${VPSMEM}MB RAM";
echo "Creating disks..."

if [ ""$IMAGE_TYPE = "lvm" ]; then
	# Remove existing partitions if they existed
	if [ -L /dev/${LVMNAME}/${VPSNAME} ] ; then
		$LVREMOVE -f /dev/${LVMNAME}/${VPSNAME}
	fi
	if [ -L /dev/${LVMNAME}/${VPSNAME}swap ] ; then
		$LVREMOVE -f /dev/${LVMNAME}/${VPSNAME}swap
	fi

	# (re)create the partitions
	if [ ! -L /dev/${LVMNAME}/${VPSNAME} ] ; then
		$LVCREATE -L${VPSHDD} -n${VPSNAME} ${LVMNAME}
		$MKDIR -p ${VPSGLOBPATH}/${VPSNUM}
	fi
	if [ ! -L /dev/${LVMNAME}/${VPSNAME}swap ] ; then
		$LVCREATE -L${VPSMEM} -n${VPSNAME}swap ${LVMNAME}
	fi
	if grep ${VPSNAME} /etc/fstab >/dev/null ; then
		echo "LV already exists in fstab"
	else
		echo "/dev/mapper/${LVMNAME}-${VPSNAME}  ${VPSGLOBPATH}/${VPSNUM} ext3    defaults,noauto 0 0" >>/etc/fstab
	fi
else
	if [ -e ${VPSGLOBPATH}/${VPSNAME}.img ]; then
		umount ${VPSGLOBPATH}/${VPSNAME}.img
		rm ${VPSGLOBPATH}/${VPSNAME}.img
	fi
	if [ -e ${VPSGLOBPATH}/${VPSNAME}.swap.img ]; then
		umount ${VPSGLOBPATH}/${VPSNAME}.swap.img
		rm ${VPSGLOBPATH}/${VPSNAME}.swap.img
	fi

	# (re)create the files
	dd if=/dev/zero of=$VPSGLOBPATH/${VPSNAME}.img bs=1M count=${VPSHDD}
        dd if=/dev/zero of=$VPSGLOBPATH/${VPSNAME}.swap.img bs=1M count=${VPSMEM}
	if grep ${VPSNAME} /etc/fstab >/dev/null ; then
		echo "LoopMount already exists in fstab: skipping"
	else
		echo "$VPSGLOBPATH/${VPSNAME}.img  ${VPSGLOBPATH}/${VPSNUM}  ext3       defaults,noauto,loop 0 0" >>/etc/fstab
	fi
fi
