﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Source files represent a source generated JsonSerializerContext as produced by the .NET 8 SDK.
// Used to validate correctness of contexts generated by previous SDKs against the current System.Text.Json runtime components.
// Unless absolutely necessary DO NOT MODIFY any of these files -- it would invalidate the purpose of the regression tests.

// <auto-generated/>

#nullable enable annotations
#nullable disable warnings

// Suppress warnings about [Obsolete] member usage in generated code.
#pragma warning disable CS0612, CS0618

namespace System.Text.Json.Tests.SourceGenRegressionTests.Net80
{
    public partial class Net80GeneratedContext
    {
        private global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList>? _MyLinkedList;
        
        /// <summary>
        /// Defines the source generated JSON serialization contract metadata for a given type.
        /// </summary>
        public global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList> MyLinkedList
        {
            get => _MyLinkedList ??= (global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList>)Options.GetTypeInfo(typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList));
        }
        
        private global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList> Create_MyLinkedList(global::System.Text.Json.JsonSerializerOptions options)
        {
            if (!TryGetTypeInfoForRuntimeCustomConverter<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList>(options, out global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList> jsonTypeInfo))
            {
                var objectInfo = new global::System.Text.Json.Serialization.Metadata.JsonObjectInfoValues<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList>
                {
                    ObjectCreator = null,
                    ObjectWithParameterizedConstructorCreator = static args => new global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList((int)args[0], (global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList)args[1]),
                    PropertyMetadataInitializer = _ => MyLinkedListPropInit(options),
                    ConstructorParameterMetadataInitializer = MyLinkedListCtorParamInit,
                    SerializeHandler = MyLinkedListSerializeHandler
                };
                
                jsonTypeInfo = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreateObjectInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList>(options, objectInfo);
                jsonTypeInfo.NumberHandling = null;
            }
        
            jsonTypeInfo.OriginatingResolver = this;
            return jsonTypeInfo;
        }

        private static global::System.Text.Json.Serialization.Metadata.JsonPropertyInfo[] MyLinkedListPropInit(global::System.Text.Json.JsonSerializerOptions options)
        {
            var properties = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfo[2];

            var info0 = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfoValues<int>
            {
                IsProperty = true,
                IsPublic = true,
                IsVirtual = false,
                DeclaringType = typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList),
                Converter = null,
                Getter = static obj => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList)obj).Value,
                Setter = static (obj, value) => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList)obj).Value = value!,
                IgnoreCondition = null,
                HasJsonInclude = false,
                IsExtensionData = false,
                NumberHandling = null,
                PropertyName = "Value",
                JsonPropertyName = null
            };
            
            properties[0] = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreatePropertyInfo<int>(options, info0);

            var info1 = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfoValues<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList>
            {
                IsProperty = true,
                IsPublic = true,
                IsVirtual = false,
                DeclaringType = typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList),
                Converter = null,
                Getter = static obj => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList)obj).Nested,
                Setter = static (obj, value) => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList)obj).Nested = value!,
                IgnoreCondition = null,
                HasJsonInclude = false,
                IsExtensionData = false,
                NumberHandling = null,
                PropertyName = "Nested",
                JsonPropertyName = null
            };
            
            properties[1] = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreatePropertyInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList>(options, info1);

            return properties;
        }

        // Intentionally not a static method because we create a delegate to it. Invoking delegates to instance
        // methods is almost as fast as virtual calls. Static methods need to go through a shuffle thunk.
        private void MyLinkedListSerializeHandler(global::System.Text.Json.Utf8JsonWriter writer, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList? value)
        {
            if (value == null)
            {
                writer.WriteNullValue();
                return;
            }
            
            writer.WriteStartObject();

            writer.WriteNumber(PropName_Value, ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList)value).Value);
            writer.WritePropertyName(PropName_Nested);
            MyLinkedListSerializeHandler(writer, ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList)value).Nested);

            writer.WriteEndObject();
        }

        private static global::System.Text.Json.Serialization.Metadata.JsonParameterInfoValues[] MyLinkedListCtorParamInit()
        {
            var parameters = new global::System.Text.Json.Serialization.Metadata.JsonParameterInfoValues[2];

            parameters[0] = new()
            {
                Name = "value",
                ParameterType = typeof(int),
                Position = 0,
                HasDefaultValue = false,
                DefaultValue = default(int)
            };
            
            parameters[1] = new()
            {
                Name = "nested",
                ParameterType = typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList),
                Position = 1,
                HasDefaultValue = false,
                DefaultValue = default(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList)
            };
            
            return parameters;
        }
    }
}
