// Generated by `wit-bindgen` 0.29.0. DO NOT EDIT!
// <auto-generated />
#nullable enable

using System;
using System.Runtime.CompilerServices;
using System.Collections;
using System.Runtime.InteropServices;
using System.Text;
using System.Collections.Generic;
using System.Diagnostics;
using System.Diagnostics.CodeAnalysis;

namespace WasiHttpWorld.wit.imports.wasi.io.v0_2_1;

internal interface IStreams {

    /**
    * An error for input-stream and output-stream operations.
    */

    internal class StreamError {
        internal readonly byte Tag;
        private readonly object? value;

        private StreamError(byte tag, object? value) {
            this.Tag = tag;
            this.value = value;
        }

        internal static StreamError lastOperationFailed(global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error lastOperationFailed) {
            return new StreamError(LAST_OPERATION_FAILED, lastOperationFailed);
        }

        internal static StreamError closed() {
            return new StreamError(CLOSED, null);
        }

        internal global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error AsLastOperationFailed
        {
            get
            {
                if (Tag == LAST_OPERATION_FAILED)
                return (global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error)value!;
                else
                throw new ArgumentException("expected LAST_OPERATION_FAILED, got " + Tag);
            }
        }

        internal const byte LAST_OPERATION_FAILED = 0;
        internal const byte CLOSED = 1;
    }

    /**
    * An input bytestream.
    *
    * `input-stream`s are *non-blocking* to the extent practical on underlying
    * platforms. I/O operations always return promptly; if fewer bytes are
    * promptly available than requested, they return the number of bytes promptly
    * available, which could even be zero. To wait for data to be available,
    * use the `subscribe` function to obtain a `pollable` which can be polled
    * for using `wasi:io/poll`.
    */

    internal class InputStream: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal InputStream(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[resource-drop]input-stream"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~InputStream() {
            Dispose(false);
        }

        internal static class ReadWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]input-stream.read"), WasmImportLinkage]
            internal static extern void wasmImportRead(int p0, long p1, nint p2);

        }

        internal   unsafe byte[] Read(ulong len)
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                ReadWasmInterop.wasmImportRead(handle, unchecked((long)(len)), ptr);

                Result<byte[], global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        var array = new byte[BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))];
                        new Span<byte>((void*)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4))), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))).CopyTo(new Span<byte>(array));

                        lifted6 = Result<byte[], global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(array);
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted6 = Result<byte[], global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class BlockingReadWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]input-stream.blocking-read"), WasmImportLinkage]
            internal static extern void wasmImportBlockingRead(int p0, long p1, nint p2);

        }

        internal   unsafe byte[] BlockingRead(ulong len)
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                BlockingReadWasmInterop.wasmImportBlockingRead(handle, unchecked((long)(len)), ptr);

                Result<byte[], global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        var array = new byte[BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))];
                        new Span<byte>((void*)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4))), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))).CopyTo(new Span<byte>(array));

                        lifted6 = Result<byte[], global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(array);
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted6 = Result<byte[], global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SkipWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]input-stream.skip"), WasmImportLinkage]
            internal static extern void wasmImportSkip(int p0, long p1, nint p2);

        }

        internal   unsafe ulong Skip(ulong len)
        {
            var handle = this.Handle;

            var retArea = new ulong[2];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                SkipWasmInterop.wasmImportSkip(handle, unchecked((long)(len)), ptr);

                Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted6 = Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 8), 8)))));
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 8), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 12), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 8), 1)[0]}");
                        }

                        lifted6 = Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class BlockingSkipWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]input-stream.blocking-skip"), WasmImportLinkage]
            internal static extern void wasmImportBlockingSkip(int p0, long p1, nint p2);

        }

        internal   unsafe ulong BlockingSkip(ulong len)
        {
            var handle = this.Handle;

            var retArea = new ulong[2];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                BlockingSkipWasmInterop.wasmImportBlockingSkip(handle, unchecked((long)(len)), ptr);

                Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted6 = Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 8), 8)))));
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 8), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 12), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 8), 1)[0]}");
                        }

                        lifted6 = Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SubscribeWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]input-stream.subscribe"), WasmImportLinkage]
            internal static extern int wasmImportSubscribe(int p0);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable Subscribe()
        {
            var handle = this.Handle;
            var result =  SubscribeWasmInterop.wasmImportSubscribe(handle);
            var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable.THandle(result));
            return resource;

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * An output bytestream.
    *
    * `output-stream`s are *non-blocking* to the extent practical on
    * underlying platforms. Except where specified otherwise, I/O operations also
    * always return promptly, after the number of bytes that can be written
    * promptly, which could even be zero. To wait for the stream to be ready to
    * accept data, the `subscribe` function to obtain a `pollable` which can be
    * polled for using `wasi:io/poll`.
    *
    * Dropping an `output-stream` while there's still an active write in
    * progress may result in the data being lost. Before dropping the stream,
    * be sure to fully flush your writes.
    */

    internal class OutputStream: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal OutputStream(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[resource-drop]output-stream"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~OutputStream() {
            Dispose(false);
        }

        internal static class CheckWriteWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]output-stream.check-write"), WasmImportLinkage]
            internal static extern void wasmImportCheckWrite(int p0, nint p1);

        }

        internal   unsafe ulong CheckWrite()
        {
            var handle = this.Handle;

            var retArea = new ulong[2];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                CheckWriteWasmInterop.wasmImportCheckWrite(handle, ptr);

                Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted6 = Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 8), 8)))));
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 8), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 12), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 8), 1)[0]}");
                        }

                        lifted6 = Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class WriteWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]output-stream.write"), WasmImportLinkage]
            internal static extern void wasmImportWrite(int p0, nint p1, int p2, nint p3);

        }

        internal   unsafe void Write(byte[] contents)
        {
            var handle = this.Handle;

            void* buffer = stackalloc byte[(contents).Length];
            contents.AsSpan<byte>().CopyTo(new Span<byte>(buffer, contents.Length));

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                WriteWasmInterop.wasmImportWrite(handle, (int)buffer, (contents).Length, ptr);

                Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(new global::WasiHttpWorld.None());
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return ;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class BlockingWriteAndFlushWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]output-stream.blocking-write-and-flush"), WasmImportLinkage]
            internal static extern void wasmImportBlockingWriteAndFlush(int p0, nint p1, int p2, nint p3);

        }

        internal   unsafe void BlockingWriteAndFlush(byte[] contents)
        {
            var handle = this.Handle;

            void* buffer = stackalloc byte[(contents).Length];
            contents.AsSpan<byte>().CopyTo(new Span<byte>(buffer, contents.Length));

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                BlockingWriteAndFlushWasmInterop.wasmImportBlockingWriteAndFlush(handle, (int)buffer, (contents).Length, ptr);

                Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(new global::WasiHttpWorld.None());
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return ;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class FlushWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]output-stream.flush"), WasmImportLinkage]
            internal static extern void wasmImportFlush(int p0, nint p1);

        }

        internal   unsafe void Flush()
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                FlushWasmInterop.wasmImportFlush(handle, ptr);

                Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(new global::WasiHttpWorld.None());
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return ;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class BlockingFlushWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]output-stream.blocking-flush"), WasmImportLinkage]
            internal static extern void wasmImportBlockingFlush(int p0, nint p1);

        }

        internal   unsafe void BlockingFlush()
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                BlockingFlushWasmInterop.wasmImportBlockingFlush(handle, ptr);

                Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(new global::WasiHttpWorld.None());
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return ;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SubscribeWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]output-stream.subscribe"), WasmImportLinkage]
            internal static extern int wasmImportSubscribe(int p0);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable Subscribe()
        {
            var handle = this.Handle;
            var result =  SubscribeWasmInterop.wasmImportSubscribe(handle);
            var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable.THandle(result));
            return resource;

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class WriteZeroesWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]output-stream.write-zeroes"), WasmImportLinkage]
            internal static extern void wasmImportWriteZeroes(int p0, long p1, nint p2);

        }

        internal   unsafe void WriteZeroes(ulong len)
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                WriteZeroesWasmInterop.wasmImportWriteZeroes(handle, unchecked((long)(len)), ptr);

                Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(new global::WasiHttpWorld.None());
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return ;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class BlockingWriteZeroesAndFlushWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]output-stream.blocking-write-zeroes-and-flush"), WasmImportLinkage]
            internal static extern void wasmImportBlockingWriteZeroesAndFlush(int p0, long p1, nint p2);

        }

        internal   unsafe void BlockingWriteZeroesAndFlush(ulong len)
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                BlockingWriteZeroesAndFlushWasmInterop.wasmImportBlockingWriteZeroesAndFlush(handle, unchecked((long)(len)), ptr);

                Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted6;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(new global::WasiHttpWorld.None());
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted6 = Result<None, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted6.IsOk) {
                    var tmp = lifted6.AsOk;
                    return ;
                } else {
                    throw new WitException(lifted6.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SpliceWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]output-stream.splice"), WasmImportLinkage]
            internal static extern void wasmImportSplice(int p0, int p1, long p2, nint p3);

        }

        internal   unsafe ulong Splice(global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.InputStream src, ulong len)
        {
            var handle = this.Handle;
            var handle0 = src.Handle;

            var retArea = new ulong[2];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                SpliceWasmInterop.wasmImportSplice(handle, handle0, unchecked((long)(len)), ptr);

                Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted7;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted7 = Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 8), 8)))));
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 8), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 12), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 8), 1)[0]}");
                        }

                        lifted7 = Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted7.IsOk) {
                    var tmp = lifted7.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted7.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class BlockingSpliceWasmInterop
        {
            [DllImport("wasi:io/streams@0.2.1", EntryPoint = "[method]output-stream.blocking-splice"), WasmImportLinkage]
            internal static extern void wasmImportBlockingSplice(int p0, int p1, long p2, nint p3);

        }

        internal   unsafe ulong BlockingSplice(global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.InputStream src, ulong len)
        {
            var handle = this.Handle;
            var handle0 = src.Handle;

            var retArea = new ulong[2];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                BlockingSpliceWasmInterop.wasmImportBlockingSplice(handle, handle0, unchecked((long)(len)), ptr);

                Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError> lifted7;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted7 = Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.ok(unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 8), 8)))));
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError lifted;

                        switch (new Span<byte>((void*)(ptr + 8), 1)[0]) {
                            case 0: {
                                var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IError.Error.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 12), 4))));

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.lastOperationFailed(resource);
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError.closed();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 8), 1)[0]}");
                        }

                        lifted7 = Result<ulong, global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.StreamError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted7.IsOk) {
                    var tmp = lifted7.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted7.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

    }

}
