#!/bin/sh
# Scan for new official sources and download file
# run with debian/get-orig-source.sh [x.y.z]

tmpdir=$(mktemp -d)
echo "tmpdir = $tmpdir"

if [ -n "$1" ]; then
    uscan_opts="--download-version=$1"
fi
echo uscan --noconf --force-download --no-symlink --verbose --destdir=$tmpdir $uscan_opts
uscan --noconf --force-download --no-symlink --verbose --destdir=$tmpdir $uscan_opts

cd $tmpdir

# Other method to download (comment uscan if you use this)
#wget https://www.dolibarr.org/files/stable/standard/dolibarr-$1.tgz

# Rename file to add +dfsg
tgzfile=$(echo *.orig.tar.gz | tr ' ' '\n' | grep -v dfsg)
version=$(echo "$tgzfile" | perl -p -e 's/^dolibarr[-_]//; s/\.tgz$//; s/\.orig\.tar\.gz$//; s/_/./g; s/\+nmu1//; ')

cd - >/dev/null

# To get the file to clean manually
mv $tmpdir/dolibarr_${version}.orig.tar.gz ../dolibarr-${version}.tgz
echo "File ../dolibarr-${version}.tgz is ready for git-import-orig"
# To get the file auto cleaned
#mv $tmpdir/dolibarr_${version}+dfsg.orig.tar.gz ../dolibarr-${version}+dfsgX.tgz
#echo "File ../dolibarr-${version}+dfsgX.tgz is ready for git-import-orig"

#rm -rf $tmpdir
