#ifndef Yagol_h
#include "Yagol.h"
#endif

#include <iostream>
#include <string>
#include <vector>


using namespace std;

template <class T>
ostream& operator<<(ostream& os, const vector<T>& vec)
{
    os << "(";
    typename vector<T>::const_iterator stop = vec.end();
    for (typename vector<T>::const_iterator it = vec.begin(); it != stop; ++it) {
        if (it != vec.begin()) {
            os << ", ";
        }
        os << *it;
    }
    os << ")";
    return os;
}


int main(int argc, char** argv)
{
    bool   b = true;
    double d = 3.1415;
    string s = "plethora";
    float  f = 2.818;
    int    i = 7;
    vector<int> v;
    v.push_back(14);
    v.push_back(28);
    v.push_back(56);
    v.push_back(112);
    
    const string appName("Minimal");
    const string appDesc("A minimal application");
    const int appSettings = yagol::AppOptionSet::STRICT_ARGUMENTS | yagol::AppOptionSet::HELP_ON_ERROR;

    yagol::AppOptionSet opts(appSettings, appName, appDesc);
    
    opts.addOption("b", "a boolean option",        &b);
    opts.addOption("d", "a double option",         &d);
    opts.addOption("s", "a string option",         &s);
    opts.addOption("f", "a float option",          &f);
    opts.addOption("i", "an int option",           &i);
    opts.addOption("v", "a vector of ints option", &v);

    opts.process(argc, argv);

    cout << "-----------------------" << endl;
    cout << "values after processing" << endl;
    cout << "-----------------------" << endl;
    cout << "    b = " << b << endl;
    cout << "    d = " << d << endl;
    cout << "    s = " << s << endl;
    cout << "    f = " << f << endl;
    cout << "    i = " << i << endl;
    cout << "    v = " << v << endl;
    
    return 0;
}
