#ifndef Test_h
#include "Test.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

/**
 * A test where all cases succeed.
 */
class SuccessTest : public Test 
{
public:
    virtual void run();
};

void SuccessTest::run() 
{
    TEST(1 == 1, "one equals one");
    TEST(2 == 2, "one equals two");
    TEST(true, "true");
}

/**
 * A test where all cases fail.
 */
class FailureTest : public Test 
{
public:
    virtual void run();
};

void FailureTest::run() 
{
    cout << "testing false condition: the next line should say 'failed'" << endl;
    TEST(1 == 2, "one equals two");
    cout << "testing false condition: the next line should say 'failed'" << endl;
    TEST(false, "false");
}

/**
 * Tests success and failure cases.
 */
class TestTest : public Test
{
public:
    virtual void run();
};

void TestTest::run()
{
    doctorj::Log::setEnabled(doctorj::Log::ALL);
    
    SuccessTest st;
    st.run();
    TEST(st.nerrors() == 0, "the success test should have no errors");

    FailureTest ft;
    ft.run();
    TEST(ft.nerrors() == 2, "the failure test should have two errors");
}

int main(int argc, char** argv) 
{
    TestTest tt;
    tt.run();
    cout << "test test results: " << tt << endl;
    return tt.nerrors();
}
