#ifndef Test_h
#include "Test.h"
#endif

#ifndef StringEdit_h
#include "StringEdit.h"
#endif

using namespace doctorj;

class StringEditReplaceTest : public Test 
{
public:
    StringEditReplaceTest();
    virtual void run();
};

StringEditReplaceTest::StringEditReplaceTest() : Test(true)
{
}

void StringEditReplaceTest::run() 
{
    //          012345678901234
    char*  c = "this is a test"; 
    string s(c);
    char*  p = c + 5;
    int    l = 2;
    StringEditReplace e("was", p, l);
    TESTEQ("was", e.str(),      "replacement string");
    TESTEQ(p,     e.position(), "replacement position");
    TESTEQ(l,     e.length(),   "replacement length");
}

int main(int argc, char** argv) 
{
    StringEditReplaceTest t;
    t.run();
    cout << "string edit replace test results: " << t << endl;
    return t.nerrors();
}
