#ifndef Test_h
#include "Test.h"
#endif

#ifndef StringEdit_h
#include "StringEdit.h"
#endif

#ifndef DebugOptions_h
#include "DebugOptions.h"
#endif

using namespace doctorj;

class StringEditMultiTest : public Test 
{
public:
    StringEditMultiTest();
    virtual void run();
};

StringEditMultiTest::StringEditMultiTest() : Test(true)
{
}

void StringEditMultiTest::run() 
{
    DebugOptions::get()->set("");

    if (true) {
        char* c = "    /**\n"
            "     * @deprecated This is DEPRECATED.\n"
            "     * @see SomethingElse\n"
            "     * @since 6.6.44\n"
            "    */";
        StringEditor editor(c);
        StringEditMulti medit;
        medit.add(new StringEditMoveAfter(c + 15, 31, c + 79)); // deprecated -> since
        medit.add(new StringEditMoveAfter(c + 54, 18, c + 14)); // see -> deprecated
        medit.add(new StringEditMoveAfter(c + 80, 13, c + 53)); // since -> see
        EditableString estr(c, c);
        medit.execute(&estr);
        string s = estr.str();
        cout << "s = '" << s << "'" << endl;

        int deppos = editor.index(c + 35);
        cout << "deppos = " << deppos << endl;
        cout << "s[" << deppos << "] = '" << s.substr(deppos) << "'" << endl;
    }
}

int main(int argc, char** argv) 
{
    StringEditMultiTest t;
    t.run();
    cout << "string edit multi test results: " << t << endl;
    return t.nerrors();
}
