#ifndef Test_h
#include "Test.h"
#endif

#ifndef SpellChecker_h
#include "SpellChecker.h"
#endif

#ifndef DebugOptions_h
#include "DebugOptions.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

using namespace doctorj;

class SpellCheckerTest : public Test 
{
public:
    SpellCheckerTest();
    virtual void run();
};

SpellCheckerTest::SpellCheckerTest() : Test(true)
{
}

void SpellCheckerTest::run() 
{
    DebugOptions::get()->set("");
    Log::setEnabled();

    SpellChecker sc;
    sc.addDictionary("/usr/share/dict/words");
    
    multimap<int, string> nearMatches;
    sc.isCorrect("inspipid", &nearMatches);

    multimap<int, string>::const_iterator it   = nearMatches.begin();
    multimap<int, string>::const_iterator stop = nearMatches.end();
    while (it != stop) {
        LOGF(1, "%d: %s", it->first, it->second.c_str())
        ++it;
    }
}

int main(int argc, char** argv) 
{
    SpellCheckerTest t;
    t.run();
    cout << "spell checker test results: " << t << endl;
    return t.nerrors();
}
