#ifndef Unzip_h
#define Unzip_h

#define UNIX_FILE_SYSTEM 1

#if defined(UNIX_FILE_SYSTEM)
    #include <stdio.h>
    #define ZIPTYPE FILE*
#elif defined(WIN32_FILE_SYSTEM)
    #define ZIPTYPE char*
#endif

namespace doctorj 
{
    /**
     * Deflates and restores contents of zip files into a byte array.
     */
    namespace Unzip
    {
        int deflate(ZIPTYPE zipfile, char* buffer);
        int deflate(ZIPTYPE zipfile, char* buffer, long buffer_length);
        int restore(ZIPTYPE zipfile, char* buffer, long buffer_length);
    }
}
    
#endif //! Unzip_h
