#ifndef RegExp_h
#define RegExp_h

#include <stdio.h>
#include <stdlib.h>

// FreeBSD needs sys/types.h before including regex.h
#include <sys/types.h>
#include <regex.h>

#include <string>
#include <iostream>

using namespace std;

namespace doctorj 
{
    /**
     * A wrapper around the POSIX regex library. See:
     * http://math.unice.fr/laboratoire/help/info/glibc/libc_280.html
     */
    class RegExp
    {
    public:
        friend ostream& operator<<(ostream& os, const RegExp& rhs);

        static const string UPPERS;

        static const string DOWNERS;

        static const string NUMBERS;

        RegExp(const string& pat);

        virtual ~RegExp();

        virtual bool match(const string& str) const;

        virtual string pattern() const;

    private:

        regex_t reg_;

        string pattern_;

    };
}

#endif //! RegExp_h
