#ifndef RCFile_h
#include "RCFile.h"
#endif

#ifndef StringUtilities_h
#include "StringUtilities.h"
#endif

#ifndef std_fstream
#define std_fstream
#include <fstream>
#endif

using namespace std;
using namespace doctorj;


RCMap::~RCMap()
{
}

int RCMap::count() const
{
    return contents_.size();
}

pair<string, string> RCMap::get(int i) const
{
    return contents_[i];
}

void RCMap::add(const string& key, const string& value)
{
    contents_.push_back(make_pair(key, value));
}

void RCMap::remove(const string& key)
{
    vector<pair<string, string> >::iterator it = contents_.begin();
    vector<pair<string, string> >::iterator stop = contents_.end();
    while (it != stop) {
        if (it->first == key) {
            contents_.erase(it);
        }
        else {
            ++it;
        }
    }
}

bool RCMap::has(const string& key) const
{
    return index(key) != -1;
}

int RCMap::index(const string& key) const
{
    int ct = count();
    for (int i = 0; i < ct; ++i) {
        pair<string, string> pr = contents_[i];
        if (pr.first == key) {
            return i;
        }
    }
    return -1;
}



RCFile::RCFile(const string& filename) : filename_(filename)
{
    ifstream iss(filename.c_str());
    while (iss) {
        string line;
        getline(iss, line);

        // this is a weak comment stripper--it will fail on the comment
        // character inside a string.
        size_t cmtpos = line.find('#');
        if (cmtpos != string::npos) {
            // strip to the end of the line
            line.erase(cmtpos);
        }

        // if the last character is a backslash, keep concatenating the lines
        while (iss && line[line.length() - 1] == '\\') {
            line = string(line, 0, line.length() - 1);
            string nextline;
            getline(iss, nextline);
            line += nextline;
        }
        
        size_t eqpos = line.find('=');
        if (eqpos != string::npos) {
            int eon = eqpos;    // end of name
            int bov = eqpos + 1; // beginning of value
            bool replace = true;
            if (line[eqpos - 1] == '+') {
                // we append, not replace
                --eon;          // back up before the '+'
                replace = false;
            }
            string name(line, 0, eon);
            string value(line, bov);
            StringUtilities::trim(&name); // trim front and back around the name
            StringUtilities::trimFront(&value); // they might have leading whitespace
            if (replace) {
                contents_.remove(name);
            }
            else {
                // adding -- nothing to remove
            }
            contents_.add(name, value);
        }
    }
}

RCFile::~RCFile()
{
}
    
int RCFile::count() const
{
    return contents_.count();
}

pair<string, string> RCFile::get(int i) const
{
    return contents_.get(i);
}

string RCFile::get(const string& name) const
{
    int idx = contents_.index(name);
    if (idx == -1) {
        return string("");
    }
    else {
        pair<string, string> pr = contents_.get(idx);
        return pr.second;
    }
}

bool RCFile::hasValue(const string& name) const
{
    return contents_.has(name);
}

string RCFile::filename() const
{
    return filename_;
}

string RCFile::operator[](const string& name) const
{
    return get(name);
}
