#ifndef DebugOptions_h
#include "DebugOptions.h"
#endif

#ifndef stdio_h
#define stdio_h
#include <stdio.h>
#endif

using namespace std;
using namespace doctorj;


DebugOptionRegistrant::DebugOptionRegistrant(char ch, const string& desc)
{
    DebugOption* opt = new DebugOption(ch, desc);
    DebugOptions* opts = DebugOptions::get();
    opts->add(opt);
}

DebugOptionRegistrant::~DebugOptionRegistrant()
{
}



DebugOption::DebugOption(char ch, const string& desc) :
        num_(-1), ch_(ch), description_(desc)
{
}

DebugOption::~DebugOption()
{
}

int DebugOption::getNumber() const
{
    return num_;
}

void DebugOption::setNumber(int n)
{
    num_ = n;
}

char DebugOption::getChar() const
{
    return ch_;
}

string DebugOption::getDescription() const
{
    return description_;
}


DebugOptions* DebugOptions::instance_ = NULL;

DebugOptions* DebugOptions::get()
{
    if (instance_ == NULL) {
        instance_ = new DebugOptions();
    }
    return instance_;
}

DebugOptions::DebugOptions() : debug_(0), num_(0)
{
}

DebugOptions::~DebugOptions()
{
}

void DebugOptions::add(DebugOption* const opt)
{
    int pos = 1 << num_;
    ++num_;
    opt->setNumber(pos);
    options_.push_back(opt);
}

string DebugOptions::allChars() const
{
    string s;
    vector<DebugOption*>::const_iterator it = options_.begin();
    vector<DebugOption*>::const_iterator stop = options_.end();
    while (it != stop) {
        DebugOption* opt = *it;
        s += opt->getChar();
        ++it;
    }
    return s;
}

void DebugOptions::writeAll(ostream& os)
{
    vector<DebugOption*>::const_iterator it = options_.begin();
    vector<DebugOption*>::const_iterator stop = options_.end();
    while (it != stop) {
        DebugOption* opt = *it;
        printf("         %12d  %c  %s\n", 
               opt->getNumber(), opt->getChar(), 
               opt->getDescription().c_str());
        ++it;
    }
}

bool DebugOptions::isEnabled(char ch) const
{
    vector<DebugOption*>::const_iterator it = options_.begin();
    vector<DebugOption*>::const_iterator stop = options_.end();
    while (it != stop) {
        DebugOption* opt = *it;
        char optCh = opt->getChar();
        if (ch == optCh) {
            return (debug_ & opt->getNumber()) != 0;
        }
        ++it;
    }
    return false;
}

bool DebugOptions::isEnabled() const
{
    return debug_ != 0;
}

void DebugOptions::set(const string& str)
{
#ifdef DEBUGGING
    debug_ = 0;
    if (isalpha(str[0])) {
        const char* debopts = allChars().c_str();
        char *d;
        for (const char* s = str.c_str(); *s && (d = strchr(debopts, *s)); s++) {
            debug_ |= 1 << (d - debopts);
        }
    }
    else {
        debug_ = atoi(str.c_str());
    }
    debug_ |= 0x80000000;

#else
    cerr << "--debug flag has no effect. This was not compiled with DEBUGGING" << endl;
#endif
}
