#ifndef ByteArray_h
#define ByteArray_h

#ifndef Types_h
#include "Types.h"
#endif

using namespace std;

namespace doctorj
{
    /**
     * Wraps an array of bytes (chars).
     */
    class ByteArray
    {
    public:
        ByteArray(char* const bytes, int nBytes);

        virtual ~ByteArray();

        /**
         * Gets the next byte.
         */
        u1 getU1();

        /**
         * Gets the next word.
         */
        virtual u2 getU2() = 0;

        /**
         * Gets the next int.
         */
        virtual u4 getU4() = 0;

        /**
         * Gets n bytes and returns a pointer to the first. The caller must
         * delete the returned bytes, which should be done as "delete []".
         */
        char* getBytes(int nBytes);

        /**
         * Skips the next n bytes.
         */
        void skip(int n);

        /**
         * Returns the current position in the buffer.
         */
        char* position() const;

    private:

        char* buffer_;
        
        char* bufptr_;

        char* bufend_;
        
    };


    /**
     * Wraps a file in a byte stream. Words and ints are retrieved as big
     * endian, that is, low bytes first.
     */
    class ByteArrayBigEndian : public ByteArray
    {
    public:
        ByteArrayBigEndian(char* const bytes, int nBytes);

        virtual ~ByteArrayBigEndian();
        
        /**
         * Gets the next word.
         */
        u2 getU2();

        /**
         * Gets the next int.
         */
        u4 getU4();

    };


}

#endif //! ByteArray_h
